BEM.MODEL.decl({ model: 'dm-cpm-deals-group', baseModel: 'dm-base-group' }, {
    //Количество редактируемых баннеров
    edit_banners_quantity: 'number',
    //Список баннеров
    banners: {
        type: 'models-list',
        modelName: 'dm-cpm-deals-banner'
    },
    // Идентификаторы баннеров в группе
    bannersIds: {
        type: 'array',
        internal: true,
        dependsFrom: 'banners',
        calculate: function() {
            return this.getBanners().map(function(banner) {
                return '' + banner.id;
            });
        }
    },
    //метки на группу объявлений
    tags: { type: 'models-list', modelName: 'm-group-tag' },
    // список id показываемых баннеров
    shownBids: { type: 'array', default: [] },
    //нужно для корректной обработки ошибок
    phrases: 'string',
    // список id фраз в баннере
    phrasesIds: { type: 'array', default: [], internal: true },
    // список id новых фраз в баннере
    newPhrasesIds: {
        type: 'array',
        default: [],
        internal: true,
        dependsFrom: 'phrasesIds',
        calculate: function() {
            return this.getPhrasesModels().reduce(function(newPhrasesIds, model) {
                // ищем только новые фразы, is_suspended(приостановленные) - не считаем
                if (model.get('state') === 'new' && !model.get('is_suspended')) {
                    newPhrasesIds.push(model.get('modelId'));
                }

                return newPhrasesIds;
            }, []);
        }
    },

    // список моделей условий ретаргетинга в группе (новые)
    retargetingsInterests: {
        type: 'models-list',
        modelName: 'dm-retargeting',
        validation: {
            rules: {
                deep: {
                    text: function(model) {
                        return model.getByIndex(0) // модель всегда одна
                            .validate().errors.map(function(error) {
                                return error.text;
                            }).join('. ');
                    }
                },
                noNegativeInterests: {
                    text: iget2(
                        'dm-cpm-deals-group',
                        'no-negative',
                        'Условие не может содержать только негативный набор.'
                    ),
                    validate: function() {
                        return this.get('retargetingsInterests').every(function(ret) {
                            return !ret.get('isNegative');
                        }, this);
                    }
                }
            },
            needToValidate: function() {
                return this.get('displayConditions') === 'crypta';
            }
        }
    },

    //показывать в превью свежие добавленные баннеры
    showNewBanners: 'boolean',
    //список новых фраз
    new_phrases: {
        type: 'array',
        internal: true,
        validation: {
            rules: {
                hasActive: {
                    text: function() {
                        return iget2(
                            'dm-cpm-deals-group',
                            'dlya-gruppy-neobhodimo-zadat',
                            'Для группы необходимо задать ключевые фразы'
                        );
                    },
                    validate: function() {
                        var count = 0,
                            state;

                        if (this.get('new_phrases').length > 0) return true;

                        this.getPhrasesModels().map(function(model) {
                            state = model.get('state');

                            if (state !== 'low_ctr' && state !== 'declined' && !model.get('is_suspended') &&
                                !model.get('is_deleted') && model.get('phrase')) {

                                count++;
                            }
                        }, this);

                        return !!count;
                    }
                },
                phraseCount: {
                    text: function() {
                        var limit = this.getKeywordLimit();
                        return u.pluralForms(iget2(
                            'dm-cpm-deals-group',
                            'gruppa-dolzhna-soderzhat-ne',
                            'Группа должна содержать не более {foo} {ключевой фразы|ключевых фраз|ключевых фраз}',
                            {
                                foo: limit
                            }
                        ), limit);
                    },
                    validate: function() {
                        return this.getPhrasesLeft() >= 0;
                    }
                }
            },
            needToValidate: function() {
                return this.get('displayConditions') === 'keywords';
            }
        }
    },
    // дневной бюджет
    day_budget: 'string',
    // кампания на автобюджетной стратегии
    autobudget: 'string',
    //статусы модерации на группу.
    status: 'string',
    // статус модерации: группа активна
    statusActive: 'string',
    // флаг, что группа не остановлена
    statusShow: 'string',
    // можно ли редактировать баннер
    isBannersEditable: 'boolean',
    //группа находится в архивной кампании
    is_camp_archived: 'number',
    //у фраз в группе могут редактироваться ставки
    isBidable: { type: 'boolean', internal: true },
    // можно просмотривать id картинки
    canViewImageId: { type: 'boolean', internal: true },
    //находимся на странице редактирования одной группы
    isSingleGroup: { type: 'boolean', internal: true },
    //идет копирование группы
    isCopyGroup: {
        type: 'boolean',
        default: false
    },
    // индекс новой группы
    newGroupIndex: { type: 'number' },
    // группа новая
    isNewGroup: { type: 'boolean' },
    // флаг об остановке мониторинга сайта
    statusMetricaStop: 'string',
    // необходимо для general_limit_price (в блоке b-edit-phrase-price)
    campDMName: {
        type: 'string',
        default: 'dm-cpm-deals-campaign',
        internal: true
    },

    // инпут «Ограничение ставки» для фраз на группу
    general_limit_price: {
        type: 'number',
        validation: function() {
            var currencyName = this.getCurrency(),
                campaignModel = this.getCampaignModel(),
                limits = u.bids.getLimits(campaignModel.name, currencyName);

            return {
                rules: {
                    required: {
                        text: iget2('dm-cpm-deals-group', 'ukazhite-stavku-dlya-novyh', 'Укажите ставку для новых условий')
                    },
                    gte: {
                        value: limits.maxPrice.value,
                        text: limits.maxPrice.errorText,
                        needToValidate: function(value) {
                            return typeof value === 'number';
                        }
                    },
                    lte: {
                        value: limits.minPrice.value,
                        text: limits.minPrice.errorText,
                        needToValidate: function(value) {
                            return typeof value === 'number';
                        }
                    }
                },
                needToValidate: function() {
                    return this.get('has_general_limit_price') &&
                        (this._isDisplayConditionChanged() || this.get('isCopyGroup'));
                }
            };
        }
    },

    // тип группы медийной кампании
    cpmGroupType: {
        type: 'enum',
        default: 'cpm_banner',
        internal: true,
        enum: ['cpm_banner', 'cpm_video', 'cpm_audio', 'cpm_outdoor', 'cpm_indoor']
    },

    // «Условия показа»
    displayConditions: {
        type: 'enum',
        default: 'crypta',
        enum: ['crypta', 'keywords']
    }

}, {

    /**
     * Возвращает true если условие показа было изменено пользователем
     * @param {String} displayCondition
     * @returns {Boolean}
     */
    isCpmGroupConditionChanged: function(displayCondition) {
        switch (displayCondition) {
            case 'keywords':
                return this.isPhrasesChanged() || this.isChanged('new_phrases');
            default:
                return false;
        }
    },

    /**
     * Возвращает креативы несоответствующие новому типу группы
     * @param {String} newCpmGroupType
     * @returns {Array}
     */
    getConflictCreatives: function(newCpmGroupType) {
        var availableCreatives = u.campaign.getCpmGroupCreatives(newCpmGroupType);

        return this.getBanners().reduce(function(result, banner) {
            var creative = banner.get('creative'),
                creativeType = creative.get('creative_type');

            if (creativeType && availableCreatives.indexOf(creativeType) === -1) {
                result.push({
                    creative_id: creative.get('creative_id'),
                    creative_type: creativeType
                });
            }

            return result;
        }, []);
    },

    /**
     * Возвращает все фразы группы
     * @returns {Array}
     */
    getAllPhrases: function() {
        return [].concat(this.get('new_phrases'), this.getPhrases());
    },

    /**
     * Возвращает количество старых фраз
     * @returns {Number}
     */
    getPhrasesLength: function() {
        return this.getPhrases().join(',').length;
    },

    /**
     * добавление баннера
     * @param {Object} defaults - дефолтные данные (для пустого баннера)
     * @returns {BEM.MODEL}
     */
    addBanner: function(defaults) {
        // отфильтровываем только новые баннеры, чтобы сделать для них свою нумерацию
        var newBanners = this.getBannersWhere({ isNewBanner: true }),
            // для нового баннера берём номер предыдущего(последнего) нового баннера в списке,
            // чтобы не было проблем после удаления одного из ранее созданных
            newBannerIndex = newBanners.length ?
                +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                1,
            newBannerId = 'new' + newBannerIndex, // для клиентов показываем отсчёт новых баннеров с 1
            modelData = u._.extend({}, defaults, {
                bid: 0,
                newBannerIndex: newBannerIndex,
                modelId: newBannerId,
                hasCopyFromPrev: false
            });

        return this.addBannerToList(modelData);
    },

    /**
     * Возвращает массив с данными по фразам, содержащимся в данной группе
     * @returns {Array}
     */
    getPhrasesData: function() {
        var _this = this,
            phrases = this.get('phrasesIds').reduce(function(goodPhrases, id) {
                var model = BEM.MODEL.getOrCreate({
                    name: _this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                    id: id,
                    parentModel: _this
                });

                // DIRECT-40060
                // исключаем пустые фразы
                model.get('phrase') && goodPhrases.push(u._.omit(model.toJSON(), ['param1', 'param2']));

                return goodPhrases;
            }, []),
            newPhrases = this.get('new_phrases');

        if (newPhrases.length) {
            phrases = phrases.concat(newPhrases.map(function(phrase) {
                return {
                    phrase: phrase,
                    id: 0
                };
            }));
        }

        return phrases;
    },

    /**
     * Возвращает true, если кроме переданной фразы других активных нет
     * @param {BEM.MODEL} phraseModel
     * @returns {Boolean}
     */
    isLastActive: function(phraseModel) {
        var state = phraseModel.get('state');

        if (this.get('new_phrases').length > 0) return false;

        if (phraseModel.get('is_suspended') ||
            state !== 'active' && state !== 'new' && state !== 'context') return false;

        var count = 0,
            modelId = phraseModel.get('modelId');

        this.getPhrasesModels().map(function(model) {
            state = model.get('state');

            if (model.get('modelId') !== modelId && state !== 'low_ctr' &&
                state !== 'declined' && !model.get('is_suspended') && !model.get('is_deleted')) {
                count++;
            }
        }, this);

        return count < 1;
    },

    /**
    * Возвращает количество ключевых фраз, которое еще можно добавить
    * @returns {Number}
    */
    getPhrasesLeft: function() {
        return this.getKeywordLimit() - this.getAllPhrases().length;
    },

    /**
     * Возвращает данные корректировок ставок
     * @returns {BEM.MODEL}
     */
    getMultipliersData: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
    },

    /**
     * Возвращает модель региона для данной группы
     * @returns {BEM.MODEL}
     */
    getGeoModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });
    },

    /**
     * Возвращает данные в формате, пригодном для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON(),
            geoModel = this.getGeoModel(),
            randPhrase = this.getRandomActivePhraseModel();

        data.banners = this.getBanners()
            .filter(function(bannerModel) { return bannerModel.get('archive') !== 'Yes'; })
            .map(function(bannerModel) {
                return bannerModel.provideData('cpm_deals');
            });

        data.tags = {};

        this.get('tags').forEach(function(model) {
            data.tags[model.get('id')] = 1;
        });

        data.geo = geoModel.get('geo');

        data.adgroup_type = 'cpm_banner';

        return data;
    },

    /**
     * Возвращает массив фраз, содержащихся в данной группе
     * @returns {Array}
     */
    getPhrases: function() {
        return this.getPhrasesModels().map(function(model) {
            return model.get('phrase');
        }, this);
    },

    /**
     * Возвращает массив с моделями фраз, содержащихся в данной группе
     * @returns {Array}
     */
    getPhrasesModels: function() {
        return this.get('phrasesIds').map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                id: id,
                parentModel: this
            });
        }, this);
    },

    /**
     * Возвращает true если хотя бы одна фраза из содержащихся в группе была изменена
     * @returns {Boolean}
     */
    isPhrasesChanged: function() {
        return this.getPhrasesModels().some(function(model) {
            return model.isChanged('phrase');
        }, this);
    },

    /**
     * Возвращает true, если ничего не выбрано
     */
    isEmptyRetargetingInterests: function() {
        return this
            .getRetargetingsInterestsData()
            .every(function(ret) {
                return !ret.groups.length;
            });
    },

    /**
     * Возвращает массив с данными по условиям ретаргетинга по интересам, содержащимся в данной группе
     * @returns {Array}
     */
    getRetargetingsInterestsData: function() {
        return this.get('retargetingsInterests').map(function(ret) {
            return ret.toJSON();
        }, this);
    },

    /**
     * Проверяет изменились ли условаия показа «Ключевые фразы», «Новые ключевые фразы», «Условия подбора аудитории»,
     * «Минус-фразы»
     * Удаление условий за изменение не считается
     * @returns {Boolean}
     * @private
     */
    _isDisplayConditionChanged: function() {
        switch (this.get('displayConditions')) {
            case 'crypta':
                // для крипты ставка является обязательным полем
                return true;

            case 'keywords':
                return !this.get('phrasesIds').length || // DIRECT-73579 - если ключевых слов нет, тогда ставка является обязательным
                    this.isPhrasesChanged() ||
                    !!this.get('newPhrasesIds').length ||
                    this.isChanged('new_phrases');
        }
    },

    /**
     * Возвращает единаую ставку для всех условий показа(«Ограничение ставки»)
     * https://wiki.yandex-team.ru/direct/TechnicalDesign/auto-price/
     * @returns {Object}
     */
    getAutoPriceData: function() {
        var generalLimitPrice = this.get('general_limit_price');

        if (this.get('has_general_limit_price')) {
            switch (this.get('displayConditions')) {
                case 'cpm_indoor':
                case 'cpm_outdoor':
                case 'crypta':
                    return { auto: 0, single_price: generalLimitPrice };
                case 'keywords':
                    // если уcловия показа не меняли, то ставку не обязательно указывать
                    return this._isDisplayConditionChanged() || this.get('isCopyGroup') ?
                        { auto: 0, single_price: generalLimitPrice } :
                        { auto: 0 };
            }
        } else {
            return { auto: 1 };
        }
    },

    /**
     * Преобразовывает серверные данные по баннеру в модельные
     * @param {Object} data
     * @returns {Object}
     */
    bannerDataToModelData: function(data) {
        return u['dm-cpm-deals-group'].transformBannerData({
            banner: data,
            group: this.provideData()
        });
    },

    /**
     * Преобразовывает серверные данные по группе в модельные (включая баннеры)
     * @param {Object} data
     * @returns {Object}
     */
    dataToModelData: function(data) {
        return u['dm-cpm-deals-group'].transformData({
            group: data
        });
    },

    /**
     * Возвращает лимит ключевых слов на группу, установленный для пользователя
     * @returns {*}
     */
    getKeywordLimit: function() {
        return this.getCampaignModel().get('maxKeywordLimit');
    },

    /**
     * Возвращает инстанс родительской модели кампании.
     *
     * @returns {BEM.MODEL}
     */
    getCampaignModel: function() {
        return this._campaignModel || (this._campaignModel = this.get('cid') ?
            BEM.MODEL.getOrCreate({ name: 'dm-cpm-deals-campaign', id: this.get('cid') }) :
            BEM.MODEL.getOne('dm-cpm-deals-campaign'));
    }
});
