u.register({

    'dm-cpm-deals-group': {

        /**
         * Преобразовывает серверные данные группы в модельные
         * @param {Object} options
         * @param {Object} options.group
         * @param {Array} options.campaignTags
         * @returns {*}
         */
        transformData: function(options) {
            var group = options.group,
                campaignTags = options.campaignTags,
                data = u._.pick(
                    group,
                    [
                        'modelId',
                        'isBidable',
                        'adgroup_id',
                        'adgroup_type',
                        'banners_quantity',
                        'banners_arch_quantity',
                        'edit_banners_quantity',
                        'has_general_limit_price',
                        'general_limit_price',
                        'cid',
                        'is_camp_archived',
                        'new_phrases',
                        'bannersCount',
                        'minus_words',
                        'shownBids',
                        'group_name',
                        'isBannersEditable',
                        'showNewBanners',
                        'newGroupIndex',
                        'isNewGroup',
                        'isCopyGroup',
                        'isSingleGroup',
                        'statusMetricaStop',
                        'statusModerate',
                        'displayConditions',
                        'cpmGroupType'
                    ]
                );

            //cyn@DIRECT-74889: для кампаний типа сделки в группу adgroup_type приходит `cpm_banner`, вместо `cpm_deals`
            data.adgroup_type = 'cpm_deals';

            if (!data.group_name) data.group_name = iget2('dm-cpm-deals-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

            //по пришедшим id тегов строим полный массив данных
            if (group.tags && !u._.isArray(group.tags)) {
                data.tags = Object.keys(group.tags).map(function(id) {
                    var cTag = (campaignTags || [])
                        .filter(function(tag) {
                            return tag.id == id;
                        })
                        .pop();

                    return {
                        id: id,
                        value: cTag && cTag.value
                    };
                });
            }

            data.banners = u._.isArray(group.banners) ?
                group.banners.map(function(banner) {
                    return u['dm-cpm-deals-group'].transformBannerData({
                        banner: banner,
                        group: group
                    });
                }) :
                [
                    u['dm-cpm-deals-group'].transformBannerData({
                        banner: group,
                        group: group
                    })
                ];

            data.phrasesIds = group.phrases ?
                group.phrases.map(function(phrase) {
                    return phrase.modelId;
                }, this) :
                [];

            data.retargetingsIds = group.retargetings ?
                group.retargetings
                    .filter(function(retargeting) {
                        return retargeting.conditions_type === 'metrika_goals';
                    })
                    .map(function(retargeting) {
                        return {
                            ret_id: retargeting.ret_id,
                            ret_cond_id: retargeting.ret_cond_id
                        };
                    }, this) :
                [];

            return data;
        },

        /**
         * Преобразовывает серверные данные баннера в модельные
         * @param {Object} options
         * @param {Object} options.banner
         * @param {Object} options.group
         * @returns {*}
         */
        transformBannerData: function(options) {
            // DIRECT-39276, DIRECT-49050: statusModerate - поле группы, но оно нужно для блока b-banner-status,
            // подобная логике есть в предобработке данных для баннеров/групп i-banners-group-data.bemtree.xjst
            options.banner.groupStatusModerate = options.group.statusModerate;

            // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
            options.banner.url_protocol || (options.banner.url_protocol = u.getUrlProtocol(options.banner.href));

            return u.bannerModelData({
                banner: u.bannerData({
                    banner: options.banner
                }),
                group: options.group,
                loadVCardFromClient: false
            });
        }

    }

});
