BEM.MODEL.decl({ model: 'dm-cpm-price-banner-group', baseModel: 'dm-base-group' }, {
    //Количество редактируемых баннеров
    edit_banners_quantity: 'number',
    //Список баннеров
    banners: {
        type: 'models-list',
        modelName: 'dm-cpm-price-banner'
    },
    // Идентификаторы баннеров в группе
    bannersIds: {
        type: 'array',
        internal: true,
        dependsFrom: 'banners',
        calculate: function() {
            return this.getBanners().map(function(banner) {
                return '' + banner.id;
            });
        }
    },
    //метки на группу объявлений
    tags: { type: 'models-list', modelName: 'm-group-tag' },
    // список id показываемых баннеров
    shownBids: { type: 'array', default: [] },

    // список моделей условий ретаргетинга в группе (новые)
    retargetingsInterests: {
        type: 'models-list',
        modelName: 'dm-retargeting',
        validation: {
            rules: {
                deep: {
                    text: iget2('dm-cpm-price-banner-group', 'ispravte-oshibki', 'Исправьте ошибки')
                },
                noNegativeInterests: {
                    text: iget2(
                        'dm-cpm-price-banner-group',
                        'no-negative',
                        'Условие не может содержать только негативный набор.'
                    ),
                    validate: function() {
                        return this.get('retargetingsInterests').every(function(ret) {
                            return !ret.get('isNegative');
                        }, this);
                    }
                },
                hasForbidToUse: {
                    validate: function() {
                        return this.get('retargetingsInterests').every(function(ret) { return ret.get('forbidToUse').length === 0 });
                    },
                    text: function() {
                        var ctx = this,
                            val = this.get('retargetingsInterests').map(function(ret) { return ret.get('forbidToUse'); }),  // [[{type: 'METRIKA_GOAL'}]]
                            typesList = u._.uniq(
                                val.reduce(function(left, right) {  // собираем одномерный список названий из списка списков объектов с полем type
                                    return left.concat(
                                        right.map(
                                            function(err) {
                                                return ctx.GOALS_FORBID_USE_NAMES[err.type];
                                            }
                                        )
                                    );
                                }, [])
                            );

                        return iget2('dm-retargeting', 'forbid-use-error', 'Ошибка сохранения {typesList}', {
                            typesList: typesList.join(', '),
                            context: 'Ошибка сохранения целей Метрики, сегментов Метрики'
                        });
                    }
                }
            },
            needToValidate: function() {
                return this.get('displayConditions') === 'crypta';
            }
        }
    },
    //можно ли настраивавть условия показа по профилю
    isAllowFrontpageProfile: 'boolean',

    //показывать в превью свежие добавленные баннеры
    showNewBanners: 'boolean',

    // дневной бюджет
    day_budget: 'string',
    // кампания на автобюджетной стратегии
    autobudget: 'string',
    //статусы модерации на группу.
    status: 'string',
    // статус модерации: группа активна
    statusActive: 'string',
    // флаг, что группа не остановлена
    statusShow: 'string',
    // можно ли редактировать баннер
    isBannersEditable: 'boolean',
    //группа находится в архивной кампании
    is_camp_archived: 'number',
    //у фраз в группе могут редактироваться ставки
    isBidable: { type: 'boolean', internal: true },
    // можно просмотривать id картинки
    canViewImageId: { type: 'boolean', internal: true },
    //находимся на странице редактирования одной группы
    isSingleGroup: { type: 'boolean', internal: true },
    //идет копирование группы
    isCopyGroup: {
        type: 'boolean',
        default: false
    },
    // индекс новой группы
    newGroupIndex: { type: 'number' },
    // группа новая
    isNewGroup: { type: 'boolean' },
    // флаг об остановке мониторинга сайта
    statusMetricaStop: 'string',

    campDMName: {
        type: 'string',
        default: 'dm-cpm-price-campaign',
        internal: true
    },

    // инпут «Ограничение ставки» для фраз на группу
    general_limit_price: {
        type: 'number',
        validation: function() {
            var currencyName = this.getCurrency(),
                campaignModel = this.getCampaignModel(),
                limits = u.bids.getLimits(
                    campaignModel.name,
                    currencyName,
                    campaignModel.get('cid'),
                    this.get('adgroup_id')
                );

            return {
                rules: {
                    required: {
                        text: iget2('dm-cpm-price-banner-group', 'ukazhite-stavku-dlya-novyh', 'Укажите ставку для новых условий')
                    },
                    gte: {
                        value: limits.maxPrice.value,
                        text: limits.maxPrice.errorText,
                        needToValidate: function(value) {
                            return typeof value === 'number';
                        }
                    },
                    lte: {
                        value: limits.minPrice.value,
                        text: limits.minPrice.errorText,
                        needToValidate: function(value) {
                            return typeof value === 'number';
                        }
                    }
                },
                needToValidate: function() {
                    return this.get('has_general_limit_price') &&
                        (this._isDisplayConditionChanged() || this.get('isCopyGroup'));
                }
            };
        }
    },

    // тип группы медийной кампании
    cpmGroupType: {
        type: 'enum',
        default: 'cpm_banner',
        internal: true,
        enum: ['cpm_banner', 'cpm_video']
    },

    // «Условия показа»
    displayConditions: {
        type: 'enum',
        default: 'empty',
        enum: ['crypta', 'empty']
    }

}, {

    /**
     * Возвращает креативы несоответствующие новому типу группы
     * @param {String} newCpmGroupType
     * @returns {Array}
     */
    getConflictCreatives: function(newCpmGroupType) {
        var availableCreatives = u.campaign.getCpmGroupCreatives(newCpmGroupType);

        return this.getBanners().reduce(function(result, banner) {
            var creative = banner.get('creative'),
                creativeType = creative.get('creative_type');

            if (creativeType && availableCreatives.indexOf(creativeType) === -1) {
                result.push({
                    creative_id: creative.get('creative_id'),
                    creative_type: creativeType
                });
            }

            return result;
        }, []);
    },

    GOALS_FORBID_USE_NAMES: {
        METRIKA_GOAL: iget2('dm-retargeting', 'metrika-goal-forbid', 'целей Метрики'),
        ECOMMERCE_GOAL: iget2('dm-retargeting', 'metrika-goal-forbid', 'целей Метрики'),
        METRIKA_SEGMENT: iget2('dm-retargeting', 'metrika-segment-forbid', 'сегментов Метрики'),
        AUDIENCE_SEGMENT: iget2('dm-retargeting', 'audience-segment-forbid', 'сегментов Аудиторий')
    },

    /**
     * Возвращает количество старых фраз
     * @returns {Number}
     */
    getPhrasesLength: function() {
        return this.getPhrases().join(',').length;
    },

    /**
     * добавление баннера
     * @param {Object} defaults - дефолтные данные (для пустого баннера)
     * @returns {BEM.MODEL}
     */
    addBanner: function(defaults) {
        // отфильтровываем только новые баннеры, чтобы сделать для них свою нумерацию
        var newBanners = this.getBannersWhere({ isNewBanner: true }),
            // для нового баннера берём номер предыдущего(последнего) нового баннера в списке,
            // чтобы не было проблем после удаления одного из ранее созданных
            newBannerIndex = newBanners.length ?
                +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                1,
            newBannerId = 'new' + newBannerIndex, // для клиентов показываем отсчёт новых баннеров с 1
            modelData = u._.extend({}, defaults, {
                bid: 0,
                newBannerIndex: newBannerIndex,
                modelId: newBannerId,
                hasCopyFromPrev: false
            });

        return this.addBannerToList(modelData);
    },

    /**
     * Возвращает данные корректировок ставок
     * @returns {BEM.MODEL}
     */
    getMultipliersData: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
    },

    /**
     * Возвращает модель региона для данной группы
     * @returns {BEM.MODEL}
     */
    getGeoModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });
    },

    /**
     * Возвращает данные в формате, пригодном для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON(),
            geoModel = this.getGeoModel(),
            cpmGroupType = this.get('cpmGroupType');

        data.banners = this.getBanners()
            .filter(function(bannerModel) { return bannerModel.get('archive') !== 'Yes'; })
            .map(function(bannerModel) { return bannerModel.provideData(cpmGroupType); });

        data.tags = {};

        this.get('tags').forEach(function(model) {
            data.tags[model.get('id')] = 1;
        });

        data.geo = geoModel.get('geo');

        data.adgroup_type = 'cpm_yndx_frontpage';
        data.cpm_banners_type = this.get('cpmGroupType');

        return data;
    },

    /**
     * Возвращает true, если ничего не выбрано
     */
    isEmptyRetargetingInterests: function() {
        return this
            .getRetargetingsInterestsData()
            .every(function(ret) {
                return !ret.groups.length;
            });
    },

    /**
     * Возвращает массив с данными по условиям ретаргетинга по интересам, содержащимся в данной группе
     * @returns {Array}
     */
    getRetargetingsInterestsData: function() {
        return this.get('retargetingsInterests').map(function(ret) {
            return ret.toJSON();
        }, this);
    },

    /**
     * Проверяет изменились ли условаия показа «Ключевые фразы», «Новые ключевые фразы», «Условия подбора аудитории»,
     * «Минус-фразы»
     * Удаление условий за изменение не считается
     * @returns {Boolean}
     * @private
     */
    _isDisplayConditionChanged: function() {
        return true;
    },

    /**
     * Возвращает единаую цену для всех условий показа(«Ограничение ставки»)
     * https://wiki.yandex-team.ru/direct/TechnicalDesign/auto-price/
     * @returns {Object}
     */
    getAutoPriceData: function() {
        var generalLimitPrice = this.get('general_limit_price');

        if (this.get('has_general_limit_price')) {
            return { auto: 0, single_price: generalLimitPrice };
        } else {
            return { auto: 1 };
        }
    },

    /**
     * Преобразовывает серверные данные по баннеру в модельные
     * @param {Object} data
     * @returns {Object}
     */
    bannerDataToModelData: function(data) {
        return u['dm-cpm-price-banner-group'].transformBannerData({
            banner: data,
            group: this.provideData()
        });
    },

    /**
     * Преобразовывает серверные данные по группе в модельные (включая баннеры)
     * @param {Object} data
     * @returns {Object}
     */
    dataToModelData: function(data) {
        return u['dm-cpm-price-banner-group'].transformData({
            group: data
        });
    },

    /**
     * Возвращает инстанс родительской модели кампании.
     *
     * @returns {BEM.MODEL}
     */
    getCampaignModel: function() {
        return this._campaignModel || (this._campaignModel = this.get('cid') ?
            BEM.MODEL.getOrCreate({ name: 'dm-cpm-price-campaign', id: this.get('cid') }) :
            BEM.MODEL.getOne('dm-cpm-price-campaign'));
    }
});
