BEM.MODEL.decl({ model: 'dm-cpm-price-banner', baseModel: 'dm-base-banner' }, {
    // тип объявления
    ad_type: 'string',

    statusMetricaStop: 'string',
    //добавить описание - DIRECT-41779
    geo_id: 'string',

    //Статус, описывающий синхронность объявления в Директе и БК.
    statusBsSynced: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sending'
        ]
    },
    //Уточнения
    callouts: { type: 'array' },

    newBannerIndex: {
        type: 'number'
    },

    has_href: {
        type: 'boolean',
        default: true
    },

    href_model: {
        type: 'model',
        modelName: 'm-banner-href',
        value: {},
        validation: {
            rules: {
                deep: {
                    text: function(model) {
                        return model.validate().errors
                            .map(function(error) { return error.text; })
                            .join('\n');
                    }
                }
            },
            needToValidate: function() {
                return this.get('has_site');
            }
        },

    },

    // поле с предупреждениями из модерации
    hash_flags: { type: 'extended-object' },

    creative: {
        type: 'model',
        modelName: 'dm-creative',
        validation: {
            rules: {
                'ad-required': {
                    text: iget2('dm-cpm-price-banner', 'neobhodimo-zagruzit-kreativ', 'Необходимо загрузить креатив'),
                    validate: function() {
                        var creative = this.get('creative');

                        return !!(creative && creative.get('creative_id'));
                    }
                }
            }
        }
    },

    audience: {
        type: 'string',
        internal: true,
        default: ''
    },

    audits: {
        type: 'array',
        internal: true,
        default: []
    },

    turbolanding: {
        type: 'model',
        modelName: 'dm-turbo-landing',
        validation: {
            rules: {
                'turbolanding-required': {
                    text: iget2('dm-cpm-banner', 'turbolanding-required', 'Необходимо выбрать Турбо-страницу'),
                    validate: function() {
                        var turbo = this.get('turbolanding');

                        return !!(+turbo.get('id'));
                    }
                }
            },
            needToValidate: function() {
                return !this.get('has_site');
            }
        },
        internal: true
    },

    turboRecommendationIsFetching: {
        type: 'boolean',
        default: false
    },

    turboRecommendation: {
        type: 'model',
        modelName: 'dm-turbo-recommendation',
    },

    turbolandingIsActive: {
        type: 'boolean',
        default: false,
        internal: true
    },

    turbolanding_href_params: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('MAX_URL_LENGTH'),
                    text: u.pluralForms(
                        iget2(
                            'dm-cpm-banner',
                            'error-message-max-length',
                            'Превышена максимальная длина строки параметров ссылки, {maxLength} {символ|символа|символов}.',
                            { maxLength: u.consts('MAX_URL_LENGTH') }),
                        u.consts('MAX_URL_LENGTH')),
                    needToValidate: function(val) {
                        return !!val
                    }
                }
            }
        }
    },

    has_site_enum: {
        type: 'enum',
        enum: ['yes', 'no'],
        internal: true
    },

    has_site: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            return this.get('has_site_enum') === 'yes';
        },
        dependsFrom: ['has_site_enum']
    },

    declined_show: 'boolean',

    tns_id: 'string',

    measurer_admetrica_enabled: 'boolean',
    measurer_admetrica_params: 'string',

    measurer_adloox_enabled: 'boolean',
    measurer_adloox_params: 'string',

    measurer_adriver_enabled: 'boolean',
    measurer_adriver_params: 'string',

    measurer_dv_enabled: 'boolean',
    measurer_dv_params: 'string',

    measurer_integral_ad_science_enabled: 'boolean',
    measurer_integral_ad_science_params: 'string',

    measurer_mediascope_enabled: 'boolean',
    measurer_mediascope_params: 'string',

    measurer_moat_enabled: 'boolean',
    measurer_moat_params: 'string',

    measurer_sizmek_enabled: 'boolean',
    measurer_sizmek_params: 'string',

    measurer_weborama_enabled: 'boolean',
    measurer_weborama_params: 'string',

    measurer_omi_enabled: 'boolean',
    measurer_omi_params: 'string'

}, {

    provideData: function() {
        var hrefObject = this.get('href_model').toJSON(),
            data = this.toJSON(),
            audience = $.trim(this.get('audience')),
            audits = this.get('audits','raw'),
            turbolanding = this.get('turbolanding').provideData();

        Object.keys(hrefObject).forEach(function(key) {
            data[key] = hrefObject[key];
        });

        if (!this.get('has_site')) {
            data.href = '';
        }

        if (audience || audits.length > 0) {
            data.pixels = [];

            audits.length > 0 && audits.forEach(function(item) {
                if (item) {
                    data.pixels.push({
                        kind: 'audit',
                        url: $.trim(item)
                    });
                }
            });

            audience && data.pixels.push({
                kind: 'audience',
                url: audience
            });
        }

        data.ad_type = 'cpm_yndx_frontpage';

        if (turbolanding) {
            data.turbolanding = turbolanding;
        }

        var measurers = u.measurers.provideModelData(data, u.consts('rights').isMeasurersEnabled);

        if (measurers.length > 0) {
            data.measurers = measurers;
        }

        return u._.omit(data, [
            'hash_flags'
        ].concat(
            u.measurers.getModelFields(),
            //  Поле tns_id опционально и разрешено для сохранения только при наличии прав
            !data.tns_id || !u.consts('rights').isTNSEnabled[data.ad_type] ? 'tns_id' : []
        ));
    },

    /**
     * Возвращает флаг используется ли в баннере уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     * @returns {Boolean}
     */
    isCalloutInUse: function(id) {
        return this.get('callouts').some(function(callout) {
            return callout.additions_item_id == id;
        });
    },

    /**
     * Удаляет из баннера уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     */
    deleteCalloutById: function(id) {
        this.set('callouts', this.get('callouts').filter(function(callout) {
            return callout.additions_item_id !== id;
        }));
    },

    hasTurboLink: function() {
        // у медийной кампании нет быстрых ссылок (в отличии от смартов), поэтому проверяем только наличие выбранной турбо страницы
        return !!+this.get('turbolanding').get('id');
    }
});
