u.register({

    'dm-cpm-yndx-frontpage-banner-group': {

        /**
         * Преобразовывает серверные данные группы в модельные
         * @param {Object} options
         * @param {Object} options.group
         * @param {Array} options.campaignTags
         * @returns {*}
         */
        transformData: function(options) {
            var group = options.group,
                campaignTags = options.campaignTags,
                data = [
                    'modelId',
                    'isBidable',
                    'adgroup_id',
                    'banners_quantity',
                    'banners_arch_quantity',
                    'edit_banners_quantity',
                    'has_general_limit_price',
                    'general_limit_price',
                    'cid',
                    'is_camp_archived',
                    'bannersCount',
                    'shownBids',
                    'group_name',
                    'isBannersEditable',
                    'showNewBanners',
                    'newGroupIndex',
                    'isNewGroup',
                    'isCopyGroup',
                    'isSingleGroup',
                    'adgroup_type',
                    'statusMetricaStop',
                    'statusModerate',
                    'displayConditions',
                    'cpmGroupType',
                    'video_goals'
                ].reduce(function(data, name) {
                    data[name] = group[name];

                    return data;
                }, {});

            data.isAllowFrontpageProfile = options.isAllowFrontpageProfile;

            // если настройка по профилю отключена и группа новая
            // говорим что условие показа "empty"
            if (!data.isAllowFrontpageProfile && options.group.isNewGroup) {
                data.displayConditions = 'empty';
            }

            if (!data.group_name) data.group_name = iget2('dm-cpm-yndx-frontpage-banner-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

            //по пришедшим id тегов строим полный массив данных
            if (group.tags && !u._.isArray(group.tags)) {
                data.tags = Object.keys(group.tags).map(function(id) {
                    var cTag = (campaignTags || [])
                        .filter(function(tag) {
                            return tag.id == id;
                        })
                        .pop();

                    return {
                        id: id,
                        value: cTag && cTag.value
                    };
                });
            }

            data.banners = u._.isArray(group.banners) ?
                group.banners.map(function(banner) {
                    return u['dm-cpm-yndx-frontpage-banner-group'].transformBannerData({
                        banner: banner,
                        group: group
                    });
                }) :
                [
                    u['dm-cpm-yndx-frontpage-banner-group'].transformBannerData({
                        banner: group,
                        group: group
                    })
                ];

            data.retargetingsIds = group.retargetings ?
                group.retargetings
                    .filter(function(retargeting) {
                        return retargeting.conditions_type === 'metrika_goals';
                    })
                    .map(function(retargeting) {
                        return {
                            ret_id: retargeting.ret_id,
                            ret_cond_id: retargeting.ret_cond_id
                        };
                    }, this) :
                [];

            // если настройка по профилю отключена, добавляем сохраненные условия показа
            if (!data.isAllowFrontpageProfile && group.retargetings) {
                data.retargetingsInterests = group.retargetings.map(function(ret) {
                    return {
                        condition_name: ret.condition_name,
                        description: ret.description,
                        groups: [],
                        price_context: ret.price_context,
                        ret_cond_id: ret.ret_cond_id,
                        ret_id: ret.ret_id,
                        type: 'interests'
                    }
                });
            }

            return data;
        },

        /**
         * Преобразовывает серверные данные баннера в модельные
         * @param {Object} options
         * @param {Object} options.banner
         * @param {Object} options.group
         * @returns {*}
         */
        transformBannerData: function(options) {
            // DIRECT-39276, DIRECT-49050: statusModerate - поле группы, но оно нужно для блока b-banner-status,
            // подобная логике есть в предобработке данных для баннеров/групп i-banners-group-data.bemtree.xjst
            options.banner.groupStatusModerate = options.group.statusModerate;

            // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
            options.banner.url_protocol || (options.banner.url_protocol = u.getUrlProtocol(options.banner.href));

            return u.bannerModelData({
                banner: u.bannerData({
                    banner: options.banner
                }),
                group: options.group,
                loadVCardFromClient: false
            });
        }

    }

});
