BEM.MODEL.decl('dm-creative', {

    creative_id: 'string',

    name: 'string',

    width: 'number',

    height: 'number',

    scale: 'number',

    preview_url: 'string',

    creative_type: 'string',

    composed_from: 'string',

    live_preview_url: 'string',

    // для outDoor
    outdoorResolutions: {
        type: 'array',
        dependsFrom: 'additional_data',
        calculate: function() {
            return ((this.get('additional_data') || {}).formats || []).map(function(item) {
                return [item.width, item.height].join('×');
            });
        }
    },

    duration: {
        type: 'string',
        default: ''
    },

    additional_data: {
        type: 'object',
        internal: true
    },

    // для cpm_audio lento4ka %(
    cpmSubtype: {
        type: 'enum',
        enum: ['', 'cpm_video', 'cpm_audio', 'cpm_outdoor', 'cpm_indoor']
    },

    has_packshot: {
        type: 'boolean',
        default: false
    },

    is_adaptive: {
        type: 'string',
        enum: ['0', '1'] // в таком виде приходит Bool из perl'а
    }

});
