/**
 * Модель настройки "Дневной бюджет" для кампании
 */
BEM.MODEL.decl('dm-day-budget2', {

    // включен/отключен
    set: {
        type: 'boolean',
        dependsFrom: ['sum'],
        calculate: function() {
            return !!this.get('sum');
        }
    },

    // режим показа
    show_mode: { type: 'string', default: 'default' },

    // сумма дневного бюджета
    sum: {
        type: 'blank-number',
        validation: function() {
            var currencyName = this.getCampaign().get('currency') || 'YND_FIXED',
                currency = u.currencies.get(currencyName);

            return {
                rules: {
                    required: {
                        text: iget2('dm-day-budget2', 'ne-ukazana-summa-dnevnogo', 'Не указана сумма дневного бюджета'),
                        validate: function(val) {
                            return !!val
                        }
                    },
                    type: {
                        text: iget2('dm-day-budget2', 'neverno-ukazana-summa-dnevnogo', 'Неверно указана сумма дневного бюджета'),
                        needToValidate: function() {
                            return !!this.get('sum')
                        }
                    },
                    lte: {
                        value: currency.MIN_DAY_BUDGET,
                        text: iget2('dm-day-budget2', 'summa-dnevnogo-byudzheta-ne', 'Сумма дневного бюджета не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(currencyName, 'MIN_DAY_BUDGET')
                        }),
                        needToValidate: function() {
                            return !!this.get('sum')
                        }
                    },
                    gte: {
                        value: currency.MAX_DAILY_BUDGET_AMOUNT,
                        text: iget2('dm-day-budget2', 'summa-dnevnogo-byudzheta-ne-103', 'Сумма дневного бюджета не может быть больше {foo}', {
                            foo: u.currencies.formatConst(currencyName, 'MAX_DAILY_BUDGET_AMOUNT')
                        }),
                        needToValidate: function() { return !!this.get('sum') }
                    }
                },

                needToValidate: function() {
                    return !!this.get('set');
                }
            };
        }
    },

    // Кол-во изменений дневного бюджета за текущий день
    daily_change_count: { type: 'number', default: 0 }
}, {

    /**
     * Возвращает модель кампании
     * @returns {BEM.MODEL}
     */
    getCampaign: function() {
        var pathArray = this._path.split('.'),
            modelParams = pathArray[pathArray.length - 2].split(':');

        return BEM.MODEL.getOne({
            name: modelParams[0],
            id: modelParams[1]
        });
    }

});
