//Шаблон динамического баннера
BEM.MODEL.decl({ model: 'dm-dynamic-banner', baseModel: 'dm-base-banner' }, {
    //добавить описание - DIRECT-41779
    image_id: 'string',
    //Изображение
    image_name: 'string',
    image_type: 'string',
    //добавить описание - DIRECT-41779
    image_BannerID: 'string',
    //Изображение
    image: 'string',

    image_model: {
        type: 'model',
        modelName: 'm-banner-pic'
    },

    //У баннера есть визитка
    has_vcard: {
        type: 'number',
        calculate: function() {
            return this.get('isVCardEmpty') || !this.get('is_vcard_open') ? 0 : 1
        },
        dependsFrom: ['isVCardEmpty', 'is_vcard_open']
    },
    //Id визитки баннера
    vcard_id: 'string',
    //визитка баннера
    vcard: {
        type: 'model',
        modelName: 'dm-vcard'
    },
    //состояние toggle да/нет на Укажите адрес для показа объявления на Яндекс.Картах
    is_vcard_open: {
        type: 'number',
        preprocess: function(val) {
            if (!val) return 0;

            return (+val);
        },
        default: 0
    },
    //состояние link скрыть/показать
    is_vcard_collapsed: {
        type: 'boolean',
        default: false
    },
    //alkaline@todo описание
    isVCardEmpty: 'boolean',
    //для показа визитки в новом окне нужно
    // использовать предварительно сформированные стабы визитки на сервере
    loadVCardFromClient: 'boolean',
    //добавить описание - DIRECT-41779
    statusMetricaStop: 'string',
    //добавить описание - DIRECT-41779
    geo_id: 'string',
    //Текст баннера
    body: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-banner', 'neobhodimo-ukazat-tekst-obyavleniya', 'Необходимо указать текст объявления')
                },
                tooLong: {
                    validate: function(val) {
                        var body = u.preview.skipSharpSign(val),
                            bodyLengthCounter = u.preview.strCounterWithoutNarrow(
                                body,
                                +u.consts('MAX_BODY_LENGTH'),
                                u.consts('NARROW_SYMBOLS')
                            );

                        return bodyLengthCounter >= 0;
                    },
                    text: iget2('dm-dynamic-banner', 'prevyshena-dopustimaya-dlina-teksta', 'Превышена допустимая длина текста объявления в {text}', {
                        text: u.pluralize([
                            iget2('dm-dynamic-banner', 'simvol', 'символ'),
                            iget2('dm-dynamic-banner', 'simvola', 'символа'),
                            iget2('dm-dynamic-banner', 'simvolov', 'символов'),
                            iget2('dm-dynamic-banner', 'simvolov', 'символов')
                        ], +u.consts('MAX_BODY_LENGTH'))
                    })
                },
                maxNarrow: {
                    validate: function(val) {
                        var narrowSymbolsRegExp = new RegExp('([' + u.consts('NARROW_SYMBOLS') + '])', 'g'),
                            body = u.preview.skipSharpSign(val),
                            narrowsLength = ((body || '').match(narrowSymbolsRegExp) || '').length;

                        return narrowsLength <= u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS');
                    },
                    text: iget2(
                        'dm-dynamic-banner',
                        'v-pole-tekst-obyavleniya',
                        'В поле "Текст объявления" вы можете использовать не более {foo} точек, запятых, двоеточий, точек с запятой, кавычек и восклицательных знаков',
                        {
                            foo: u.consts('MAX_NUMBER_OF_NARROW_CHARACTERS')
                        }
                    )
                },
                noLongWords: {
                    validate: function(val) {
                        // Увеличение лимита на 1 требуется чтобы слово длинной 23 символа было валидным
                        // т.к. регулярное выражение подразумевает логику >=
                        var maxUniLength = u.consts('MAX_BODY_UNINTERRUPTED_LENGTH') + 1;

                        return !(new RegExp('[а-яА-ЯёЁA-Za-z0-9_]{' + maxUniLength + ',}').test(val));
                    },
                    // не выписываем в сообщении об ошибке само ошибочное слово, так как оно может быть слишком длинным
                    text: u.pluralForms(
                        iget2(
                            'dm-dynamic-banner',
                            'v-tekste-dinamicheskih-obyavleniy',
                            'В тексте динамических объявлений недопустимы слова длиной более {foo} {знака|знаков|знаков}',
                            {
                                foo: u.consts('MAX_BODY_UNINTERRUPTED_LENGTH')
                            }
                        ),
                        u.consts('MAX_BODY_UNINTERRUPTED_LENGTH'))
                },
                noInvalidSymbols: {
                    validate: function(val) {
                        // eslint-disable-next-line max-len
                        return !(new RegExp('[^' + u.consts('ALLOW_BANNER_LETTERS').replace(/\\/g, '').replace(/[.?*+^$[\]\\(){}|-]/g, '\\$&') + '\\\\]').test(val));
                    },
                    text: iget2(
                        'dm-dynamic-banner',
                        'v-tekste-reklamnogo-soobshcheniya',
                        'В тексте рекламного сообщения можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                    )
                },
                noTempates: {
                    validate: function(val) {
                        return !/#.*#/.test(val);
                    },
                    text: iget2(
                        'dm-dynamic-banner',
                        'v-tekste-dinamicheskih-obyavleniy-104',
                        'В тексте динамических объявлений не допускается использование шаблонов'
                    )
                }
            }
        },
        format: u.preview.prettifyText,
        preprocess: function(value) {
            return typeof value === 'string' ? value.replace('\n', ' ') : value;
        }
    },
    //Статус, описывающий синхронность объявления в Директе и БК.
    statusBsSynced: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sending'
        ]
    },
    //Результат модерации быстрых ссылок объявлений
    statusSitelinksModerate: {
        type: 'enum',
        enum: [
            'New',
            'Sent',
            'Sending',
            'Ready',
            'Yes',
            'No'
        ]
    },
    //Уточнения
    callouts: { type: 'array' },
    //Сайтлинки
    sitelinks: {
        type: 'model',
        modelName: 'm-banner-sitelinks'
    },

    newBannerIndex: {
        type: 'number'
    },

    // alkaline@todo убрать подписку из превью?
    // выпилить после поддержки в превью разных типов баннеров
    domain: 'string',
    has_href: { //для динамического объявления - это константа
        type: 'boolean',
        calculate: function() {
            return true;
        }
    },
    href_model: {
        type: 'model',
        modelName: 'm-banner-href',
        value: {}
    },
    title: {
        type: 'string',
        default: u.dynamicGroupsData.getBannerTitle()
    },

    // поле с предупреждениями из модерации
    hash_flags: { type: 'extended-object' }

}, {
    provideData: function() {
        var hrefObject = this.get('href_model').toJSON(),
            imageObject = this.get('image_model').toJSON(),
            data = this.toJSON();

        data.sitelinks = this.get('sitelinks').provideData();

        if (!data.has_vcard) {
            delete data.vcard;
            delete data.vcard_id;
        }

        delete data.hash_flags;

        Object.keys(hrefObject).forEach(function(key) {
            data[key] = hrefObject[key];
        });
        Object.keys(imageObject).forEach(function(key) {
            data[key] = imageObject[key];
        });

        //ageInstalled может быть undefined (если им не манипулировали), true или false
        if (this.get('ageInstalled') === false) {
            delete data.age;
        }

        return data;
    },

    /**
     * Возвращает данные визитки
     * @returns {Object}
     */
    getVCardData: function() {
        return this.get('vcard').toJSON();
    },

    /**
     * Возвращает флаг используется ли в баннере уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     * @returns {Boolean}
     */
    isCalloutInUse: function(id) {
        return this.get('callouts').some(function(callout) {
            return callout.additions_item_id == id;
        });
    },

    /**
     * Удаляет из баннера уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     */
    deleteCalloutById: function(id) {
        this.set('callouts', this.get('callouts').filter(function(callout) {
            return callout.additions_item_id !== id;
        }));
    }
});
