BEM.MODEL.decl('dm-dynamic-condition', {
    //Id условия
    dyn_id: 'id',
    //Является ли новым, то есть еще не сохраненным на сервере
    isNew: { type: 'boolean', default: true },
    //Название условия
    condition_name: 'string',
    //id группы, к которой принадлежит условие
    adgroup_id: 'string',
    //Статистика показов на поиске
    shows: 'number',
    //Статистика ctr на поиске
    ctr: 'number',
    //Статистика кликов на поиске
    clicks: 'number',
    //Статистика показов на контексте
    ctx_shows: 'number',
    //Статистика ctr на контексте
    ctx_ctr: 'number',
    //Статистика кликов на контексте
    ctx_clicks: 'number',
    //Ставка на поиске
    price: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currCode = BEM.MODEL.getOne({ name: 'm-campaign' }).get('currency'),
                currency = u.consts('currencies')[currCode],
                strategy = this.get('strategy'),
                needValidFlag = !strategy.is_autobudget && (!strategy.name ||
                    (strategy.name == 'different_places' && !strategy.is_search_stop));

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2(
                            'dm-dynamic-condition',
                            'vvedeno-nekorrektnoe-znachenie-minimalnoe',
                            'Введено некорректное значение. Минимальное: {foo}',
                            {
                                foo: currency.MIN_PRICE
                            }
                        ),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2('dm-dynamic-condition', 'ukazano-slishkom-bolshoe-znachenie', 'Указано слишком большое значение. Максимум: {foo}', {
                            foo: currency.MAX_PRICE
                        }),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                }
            };
        }
    },

    /**
     * Ставка на контекстных площадках
     */
    price_context: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currCode = BEM.MODEL.getOne({ name: 'm-campaign' }).get('currency'),
                currency = u.consts('currencies')[currCode],
                strategy = this.get('strategy'),
                needValidFlag = (strategy.name == 'different_places' && !strategy.is_autobudget);

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2('dm-dynamic-condition', 'vvedeno-nekorrektnoe-znachenie-minimum', 'Введено некорректное значение. Минимум: {foo}', {
                            foo: currency.MIN_PRICE
                        }),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2('dm-dynamic-condition', 'ukazano-slishkom-bolshoe-znachenie', 'Указано слишком большое значение. Максимум: {foo}', {
                            foo: currency.MAX_PRICE
                        }),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                }
            };
        }
    },
    //Является ли условие отключенным пользователем
    is_suspended: 'boolean',
    //Является ли условие удаленным пользователем
    is_deleted: 'boolean',
    //список целей
    condition: {
        type: 'models-list',
        modelName: 'dm-dynamic-goal'
    },

    /**
     * стратегия кампании
     */
    strategy: {
        type: 'object',
        internal: true,
        calculate: function() {
            var campaign = BEM.MODEL.getOne({ name: 'm-campaign' }),
                result = campaign.get('strategy');

            result.is_autobudget = result.is_autobudget || campaign.get('is_autobudget');

            return result;
        }
    },

    /**
     * валюта кампании
     */
    currency: {
        type: 'object',
        internal: true,
        calculate: function() {
            return BEM.MODEL.getOne({ name: 'm-campaign' }).get('currency');
        }
    }
}, {
    /**
     * Возвращает массив используемых связок type + kind + value вложенных целей
     */
    getGoalsState: function() {
        return this.get('condition').map(function(model) {
            return model.getStateString();
        });
    },

    provideData: function() {
        var strategy = this.get('strategy'),
            fieldsToPick = [
                'dyn_id',
                'condition_name',
                'adgroup_id',
                !strategy.is_autobudget &&
                    (!strategy.name || (strategy.name == 'different_places' && strategy.search_strategy !== 'stop')) &&
                        'price',
                strategy.name == 'different_places' && !strategy.is_autobudget && 'price_context',
                'condition',
                'is_suspended'
            ].filter(Boolean),
            result = u._.pick(this.toJSON(), fieldsToPick);

        if (this.get('isNew')) {
            result.dyn_id = '';
        }

        return result;
    }
});
