BEM.MODEL.decl({ model: 'dm-dynamic-group', baseModel: 'dm-base-group-with-feeds' }, {

    // Происходит копирование группы
    is_group_copy_action: 'boolean',

    // Имя группы объявлений
    group_name: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-group', 'neobhodimo-ukazat-nazvanie-gruppy', 'Необходимо указать название группы')
                },
                maxLength: {
                    value: 1024,
                    text: iget2('dm-dynamic-group', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 1024
                    }),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // объявления группы
    banners: {
        type: 'models-list',
        modelName: 'dm-dynamic-banner'
    },

    // Главный (родительский) домен динамических объявлений
    main_domain: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-group', 'neobhodimo-ukazat-domen', 'Необходимо указать домен')
                }
            },
            needToValidate: function() {
                return this.get('data_source') === 'domain';
            }
        }
    },

    // динамические фильтры, переопределяем поле из dm-base-group-with-feeds - для ДО у feed_filters есть дополнительные правила валидации
    feed_filters: {
        type: 'models-list',
        modelName: 'dm-feed-filter',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-group', 'dobavte-v-gruppu-filtry', 'Добавьте в группу фильтры'),
                    validate: function() {
                        return !!this.get('feed_filters').length()
                    }
                },

                invalidCatrgories: {
                    text: iget2('dm-dynamic-group', 'nekorrektnye-usloviya-filtracii', 'Некорректные условия фильтрации'),
                    validate: function() {
                        return this.get('feed_filters').every(function(filter) {
                            return !filter.get('isIncorrect');
                        })
                    }
                }
            },
            needToValidate: function() {
                return this.get('data_source') === 'feed';
            }
        }
    },

    //идентификатор фида, если фид не задан, feed_id == 0, переопределяем поле из dm-base-group-with-feeds - для ДО у feed_id есть дополнительные правила валидации
    feed_id: {
        type: 'number',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-group', 'vyberite-fid', 'Выберите фид'),
                    validate: function(val) {
                        return !!val;
                    }
                }
            },
            needToValidate: function() {
                return this.get('data_source') === 'feed';
            }
        }
    },

    data_source: {
        type: 'string'
    },

    // Параметры ссылок
    href_params: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: 1024,
                    text: iget2('dm-dynamic-group', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 1024
                    }),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    /**
     * Рейтинг магазина в маркете
     */
    market_rating: {
        type: 'number',
        default: -1
    },

    /**
     * Прошел ли домен аякс-проверку
     */
    isMainDomainValid: {
        type: 'boolean',
        default: true,
        validation: {
            text: iget2('dm-dynamic-group', 'domen-ukazan-neverno', 'Домен указан неверно'),
            validate: function() {
                return this.get('isMainDomainValid') == true;
            },
            needToValidate: function() {
                return this.get('data_source') === 'domain'
            }
        }
    },

    // условия нацеливания
    dynamic_conditions: {
        type: 'models-list',
        modelName: 'dm-dynamic-condition',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-group', 'zadayte-uslovie-nacelivaniya-ili', 'Задайте условие нацеливания или выберите "Все страницы сайта"'),
                    validate: function(val) {
                        return this.get('dynamic_conditions').length() > 0;
                    }
                },
                validPrices: {
                    text: iget2('dm-dynamic-group', 'ukazhite-korrektnye-stavki', 'Укажите корректные ставки'),
                    validate: function() {
                        var firstCondition = this.get('dynamic_conditions').getByIndex(0);

                        return firstCondition.isValid();
                    },

                    needToValidate: function() {
                        var conditions = this.get('dynamic_conditions');

                        if (conditions.length()) {
                            var firstCondition = conditions.getByIndex(0),
                                goals = firstCondition.get('condition'),
                                firstGoal = goals.getByIndex(0);

                            return conditions.length() == 1 && firstGoal.get('type') == 'any';
                        } else {
                            return false;
                        }
                    }
                }
            },
            needToValidate: function() {
                return this.get('data_source') === 'domain'
            }
        }
    },

    // статус, описывающий синхронность группы в Директе и БК.
    statusBsSynced: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sending'
        ]
    },

    // состояние прогноза показов.
    statusShowsForecast: {
        type: 'string',
        enum: [
            'New',
            'Processed',
            'Sending',
            'Archived'
        ]
    },

    tags: { type: 'models-list', modelName: 'm-group-tag' },

    /* копипаста из m-group  */
    isSingleGroup: { type: 'boolean' },
    //идет копирование группы
    isCopyGroup: { type: 'boolean' },
    newGroupIndex: { type: 'number' },
    isNewGroup: { type: 'boolean' },
    adgroup_type: {
        type: 'string',
        default: 'dynamic'
    },
    autobudget: 'string',
    bannersIds: {
        type: 'array',
        internal: true,
        dependsFrom: 'banners',
        calculate: function() {
            return this.get('banners').map(function(banner) {
                return '' + banner.get('bid');
            });
        }
    },

    //Пользователь может выбирать источник данных в группе
    canSelectDataSource: {
        type: 'boolean',
        internal: true,
        dependsFrom: ['isCopyGroup', 'isNewGroup'],
        calculate: function() {
            return this.get('isCopyGroup') || this.get('isNewGroup');
        }
    }
}, {

    /**
     * Возвращает данные в формате, пригодном для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON();

        data.banners = this.get('banners').map(function(bannerModel) {
            return bannerModel.provideData();
        });

        if (data.data_source == 'domain') {
            data.dynamic_conditions = (this.get('dynamic_conditions') || []).map(function(condition) {
                return condition.provideData();
            });

            delete data.feed_id;
        } else {
            data.dynamic_conditions = (this.get('feed_filters') || []).map(function(filter) {
                return filter.provideData();
            });

            delete data.feed_filters;
            delete data.main_domain;
        }

        data.tags = this.get('tags').map(function(tag) { return tag.get('value'); });
        data.geo = this.getGeoModel().get('geo');
        data.hierarchical_multipliers = this.getMultipliersData();

        return data;
    },

    getMultipliersData: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
    },

    /**
     * Возвращает модель региона для данной группы
     * @returns {BEM.MODEL}
     */
    getGeoModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });
    },

    addBanner: function() {
        var newBanners = this.getBanners().filter(function(model) {
                return model.get('isNewBanner');
            }),
            newBannerIndex = newBanners.length ?
                +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                1,
            newBannerId = 'new' + newBannerIndex,
            commonVCard = this.getCampaignModel().get('common_vcard_set') ?
                BEM.MODEL.getOrCreate({ name: 'm-vcard', id: 'common' }).toJSON() :
                {};

        return this.addBannerToList({
            bid: 0,
            newBannerIndex: newBannerIndex,
            modelId: newBannerId,
            hasCopyFromPrev: true,
            vcard: commonVCard,
            loadVCardFromClient: true
        });
    },

    /**
     * Преобразовывает серверные данные по баннеру в модельные
     * @param {Object} data
     * @returns {Object}
     */
    bannerDataToModelData: function(data) {
        return u['dm-dynamic-group'].transformBannerData({
            banner: data,
            group: this.provideData()
        });
    },

    /**
     * Преобразовывает серверные данные по группе в модельные (включая баннеры)
     * @param {Object} data
     * @returns {Object}
     */
    dataToModelData: function(data) {
        return u['dm-dynamic-group'].transformData({
            group: data,
            defaultDynamicConditions: {
                by_domain: [],
                by_feed: []
            }
        });
    },

    clearConditions: function() {
        this.get('dynamic_conditions').clear();
    },

    addAnyCondition: function() {
        var currCode = this.getCampaignModel().get('currency'),
            currency = u.consts('currencies')[currCode];

        this.get('dynamic_conditions').add({
            dyn_id: 'new1',
            condition_name: 'any',
            price: currency.MIN_PRICE,
            price_context: currency.MIN_PRICE,
            condition: [{ type: 'any' }]
        });
    },

    getPhrasesModels: function() {
        return false;
    },

    /**
     * Возвращает массив баннеров в которых используется уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     * @returns {Array}
     */
    getBannersWithCalloutId: function(id) {
        return this.get('banners').filter(function(bannerModel) {
            return bannerModel.isCalloutInUse(id);
        })
    }
});
