u.register({

    'dm-dynamic-group': {

        /**
         * Преобразовывает серверные данные в модельные
         * @param {Object} options
         * @param {String} options.cid
         * @param {Object} options.group
         * @param {Array} options.campaignTags
         * @param {Boolean} options.loadVCardFromClient
         * @returns {Object}
         */
        transformData: function(options) {
            var group = options.group,
                campaignTags = options.campaignTags,
                defaultDynamicConditions = u._.cloneDeep(options.defaultDynamicConditions || {}), //клонируем умолчательные условия/фильтры чтобы не модифицировать их в разных вызовах
                loadVCardFromClient = options.loadVCardFromClient,
                data = u._.pick(group, [
                    'is_group_copy_action',
                    'modelId',
                    'adgroup_id',
                    'banners',
                    'banners_quantity',
                    'banners_arch_quantity',
                    'group_banners_types',
                    'main_domain',
                    'feed_id',
                    'href_params',
                    'dynamic_conditions',
                    'statusModerate',
                    'statusPostModerate',
                    'statusBsSynced',
                    'statusShowsForecast',
                    'strategy',
                    'cid',
                    'minus_words',
                    'geo',
                    'tags',
                    'group_name',
                    'adgroup_type',
                    'autobudget',
                    'isNewGroup',
                    'newGroupIndex',
                    'isSingleGroup',
                    'isCopyGroup',
                    'market_rating',
                    'statusMetricaStop'
                ]);

            if (!data.group_name) data.group_name = iget2('dm-dynamic-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

            //Если определен фид, то источник данных - фид. В противном случае - источник данных - сайт
            data.data_source = !+data.feed_id ? 'domain' : 'feed';

            if (!data.cid) {
                data.cid = options.cid;
            }

            //по пришедшим id тегов строим полный массив данных
            if (group.tags && !u._.isArray(group.tags)) {
                data.tags = Object.keys(group.tags).map(function(id) {
                    var cTag = (campaignTags || [])
                        .filter(function(tag) {
                            return tag.id == id;
                        })
                        .pop();

                    return {
                        id: id,
                        value: cTag && cTag.value
                    };
                });
            }

            data.dynamic_conditions = group.main_domain && group.dynamic_conditions && group.dynamic_conditions.length ?
                group.dynamic_conditions.map(function(cond, i) {
                    return u['dm-dynamic-group'].transformDynamicConditionData(cond, i);
                }) :
                defaultDynamicConditions.by_domain;

            data.banners = group.banners.map(function(banner) {
                return u['dm-dynamic-group'].transformBannerData({
                    banner: banner,
                    group: group,
                    loadVCardFromClient: loadVCardFromClient
                });
            });

            data.feed_filters = u['dm-feed-filter'].transformData({
                feedFilters: group.feed_id && group.dynamic_conditions && group.dynamic_conditions.length ?
                    group.dynamic_conditions :
                    defaultDynamicConditions.by_feed || [],
                adgroupType: data.adgroup_type,
                adgroupId: data.modelId
            });

            return data;
        },

        /**
         * Преобразовываем данные условия нацеливания из серверных в модельные
         * @param {Object} condition условие нацеливания
         * @param {Number} i номер условия в массиве
         * @returns {Object}
         */
        transformDynamicConditionData: function(condition, i) {
            condition.isNew = (condition.dyn_id == null || condition.dyn_id == 0);
            condition.dyn_id = condition.dyn_id || ('New' + i);
            //сервер присылает отношение exists в виде строки 1, а мы все value на клиенте храним в массиве
            condition.condition = condition.condition.map(function(cond) {
                if (cond.relation === 'exists') { cond.value = [cond.value]; }

                return cond;
            });

            return condition;
        },

        /**
         * Преобразовывает серверные данные баннера в модельные
         * @param {Object} options
         * @param {Object} options.banner
         * @param {Object} options.group
         * @param {Boolean} options.loadVCardFromClient
         * @returns {*}
         */
        transformBannerData: function(options) {
            // DIRECT-39276, DIRECT-49050: statusModerate - поле группы, но оно нужно для блока b-banner-status,
            // подобная логике есть в предобработке данных для баннеров/групп i-banners-group-data.bemtree.xjst
            options.banner.groupStatusModerate = options.group.statusModerate;

            // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
            options.banner.url_protocol || (options.banner.url_protocol = u.getUrlProtocol(options.banner.href));

            return u.bannerModelData({
                banner: u.bannerData({
                    banner: options.banner
                }),
                group: options.group,
                loadVCardFromClient: options.loadVCardFromClient
            });
        }

    }

});
