BEM.MODEL.decl({ model: 'dm-dynamic-media-banner', baseModel: 'dm-base-banner' }, {
    //id группы
    adgroup_id: 'string',
    //id кампании
    cid: 'string',
    //id баннера, если id еще нет, то должен приходить 0
    bid: {
        type: 'number',
        default: 0
    },
    creative: {
        type: 'model',
        modelName: 'dm-dynamic-media-creative'
    },
    enable: 'boolean',

    //номер нового объявления
    newBannerIndex: 'number',

}, {

    /**
     * Извлекает данные из модели баннера
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON();

        data.creative && u._.extend(data, {
            creative_id: data.creative.creative_id
        });

        return data;
    }

});
