(function() {
    var errorText = iget2('dm-dynamic-media-campaign', 'nevernoe-znachenie-urovnya-ostatka', 'Неверное значение уровня остатка средств'),
        boolToFlag = function(val) {
            return +(!!val);
        };

    BEM.MODEL.decl('dm-dynamic-media-campaign', {
        active_orders_money_out_sms: { type: 'boolean', preprocess: boolToFlag },
        active_orders_money_warning_sms: { type: 'boolean', preprocess: boolToFlag },
        camp_banners_domain: 'string',
        ClientID: 'string',
        cid: 'string',
        camp_finished_sms: { type: 'boolean', preprocess: boolToFlag },
        ContextLimit: 'string',
        ContextPriceCoef: 'string',
        // Показы на тематических площадках запрещены
        dontShowYacontext: 'string',
        currency: 'string',
        // @deprecated
        day_budget: 'number',
        // @deprecated
        day_budget_show_mode: 'string',

        // настройка "Дневной бюджет"
        day_budget2: {
            type: 'model',
            modelName: 'dm-day-budget2'
        },

        // настройка "модель атрибуции"
        attribution_model: {
            type: 'enum',
            enum: ['last_yandex_direct_click', 'last_significant_click', 'last_click', 'first_click'],
            default: 'last_yandex_direct_click'
        },

        // стратегия кампании
        strategy2: {
            type: 'model',
            modelName: 'dm-campaign-strategy2'
        },

        // Данные по целям Яндекс Метрики
        metrika: {
            type: 'model',
            modelName: 'dm-metrika'
        },

        device_targeting: 'string', // таргетинг на устройства
        enable_cpc_hold: 'string', // удерживать цену клика на тематических площадках ниже цены клика на поиске
        disabledIps: 'string',

        // доступные ssp-площадки
        ssp_platforms: 'array',
        // заблокированные ssp-площадки
        disabled_ssp: 'array',

        DontShow: 'array', // запрещенные площадки
        email: 'string',
        email_notify_paused_by_day_budget: { type: 'boolean', preprocess: boolToFlag },
        finish_date: 'string',
        fio: 'string',
        geo: 'string',
        geoText: 'string',
        groupId: 'string',
        hasPlatformSelect: 'boolean',
        // @deprecated
        is_autobudget: 'boolean',
        mediaType: 'string',
        metrika_counters: {
            type: 'string',
            validation: {
                rules: {
                    required: {
                        text: iget2('dm-dynamic-media-campaign', 'ne-ukazan-schetchik-metriki', 'Не указан счетчик Метрики')
                    }
                }
            }
        },
        minus_words: 'array',
        moderate_result_sms: { type: 'boolean', preprocess: boolToFlag },
        paused_by_day_budget_sms: { type: 'boolean', preprocess: boolToFlag },
        money_warning_value: {
            type: 'number',
            precision: 0,
            validation: {
                rules: {
                    required: errorText,
                    type: errorText,
                    lte: {
                        value: 1,
                        text: errorText
                    },
                    gte: {
                        value: u.consts('MAX_MONEY_WARNING_VALUE') || 50,
                        text: errorText
                    }
                }
            }
        },
        name: {
            type: 'string',
            validation: {
                rules: {
                    required: {
                        text: iget2('dm-dynamic-media-campaign', 'ne-zapolneno-pole-nazvanie', 'Не заполнено поле "Название кампании"')
                    }
                }
            }
        },
        nobsdata: 'boolean', // флаг говорящий о том, что бк не отвечает (DIRECT-21557)
        notify_metrica_control_sms: { type: 'boolean', preprocess: boolToFlag },
        notify_order_money_in_sms: { type: 'boolean', preprocess: boolToFlag },
        // @deprecated
        net_strategy: 'string',
        offlineStatNotice: { type: 'boolean', preprocess: boolToFlag }, // excel отчеты
        phrases_inited: 'boolean',
        // @deprecated
        places_strategy: { type: 'string', default: 'search' },
        platform: 'string',
        platform_select: 'boolean',
        product_type: 'string',
        readonly: 'boolean',
        // @deprecated
        search_strategy: 'string',
        sendAccNews: { type: 'boolean', preprocess: boolToFlag },
        sendWarn: { type: 'boolean', preprocess: boolToFlag },
        showPmax: 'boolean',
        sms_phone: 'string',
        sms_time_hour_from: 'number',
        sms_time_hour_to: 'number',
        sms_time_min_from: 'number',
        sms_time_min_to: 'number',
        spent_today: { type: 'number' },
        start_date: {
            type: 'string',
            validation: {
                rules: {
                    required: {
                        text: iget2('dm-dynamic-media-campaign', 'vy-dolzhny-ukazat-datu', 'Вы должны указать дату старта кампании')
                    }
                }
            }
        },
        statusContextStop: 'string',
        statusMetricaControl: 'flag',
        statusOpenStat: 'flag',
        status_click_track: 'flag',
        // @deprecated
        strategy: 'object',
        // @deprecated
        strategy_name: 'string',
        sum_rest: { type: 'number', default: 0 },
        tags: { type: 'models-list', modelName: 'm-campaign-tag', defaults: { value: [] } },
        timetarget_coef: 'string',
        title: 'string',
        ulogin: 'string',
        untagged_banners_num: { type: 'number', precision: 0 },
        vcard: {},
        warnPlaceInterval: 'string',
        with_ci: 'flag',
        campaignIsArchived: 'boolean',
        currentTab: 'string',
        countArchTab: 'number',
        countOffTab: 'number',
        //установлена общая визитка на кампанию
        common_vcard_set: 'boolean',

        //adgroup_id выбранных в текущий момент в интерфейсе баннеров
        selectedAdgroupIds: 'array',
        //Сумма указанная пользователем как сумма к оплате
        sumInput: {
            type: 'blank-number',
            precision: 2,
            internal: true,
            validation: {
                rules: {
                    type: {
                        text: iget2('dm-dynamic-media-campaign', 'nepravilno-ukazana-summa', 'Неправильно указана сумма')
                    },
                    min: {
                        value: 0,
                        text: iget2('dm-dynamic-media-campaign', 'nepravilno-ukazana-summa', 'Неправильно указана сумма')
                    }
                },
                needToValidate: function() {
                    //0 - это нормальное значение, которое надо валидировать
                    return !!this.get('sumInput') || this.get('sumInput') === 0;
                }
            }
        },

        isCpaPayForConversionEnabled: 'boolean',

        //установлен общий регион на кампанию
        common_geo_set: 'boolean',
        common_geo: 'string',
        // максимальная ставка при автобюджете
        autobudget_bid: 'string',
        // включен ли для кампании автобюджет
        autobudget: 'string',
        //число групп в кампании todo - переименовать
        banners_count: 'number',
        isCampShows: 'boolean',
        // Отключена подстановка части текста в заголовок в баннера (поиск - десктоп)
        no_title_substitute: 'number',
        //Возможность редактировать баннеры, allow_edit_camp(s) на страницах статистики
        editable: 'boolean',
        new_camp: 'boolean',
        // Флаг говорит о том, что опция "Расширенный географический таргетинг" отключена
        no_extended_geotargeting: {
            type: 'enum',
            enum: [0, 1]
        },
        // ключевые цели метрики (DIRECT-73912)
        meaningful_goals: 'array',
        // счетчики используемые в экспериментах
        counters_in_experiments: 'object',
        // включить/выключить фильтрацию площадок для показа по списку запрещенных доменов
        require_filtration_by_dont_show_domains: 'boolean'
    }, {

        /**
         * Возвращает массив с группами, выбранными в текущий момент в интерфейсе
         * @returns {Array}
         */
        getSelectedGroups: function() {
            return this.get('selectedAdgroupIds').map(function(adgroupId) {
                return this.getChildGroupById(adgroupId);
            }, this)
        },

        /**
         * Возвращает название для дочерних моделей групп
         * @returns {string}
         */
        getChildGroupModelName: function() {
            return u.campaign.getGroupModelName(this.get('mediaType'));
        },

        /**
         * Возвращает дочерние модели групп по их adgroup_id
         * @param {Array} adgroupsIds
         * @returns {MODEL}
         */
        getChildGroupsByIds: function(adgroupsIds) {
            var modelName = this.getChildGroupModelName();

            return adgroupsIds.map(function(id) {
                return BEM.MODEL.getOrCreate({ id: id, name: modelName })
            });
        },

        /**
         * Возвращает дочернюю группу по ее id
         * @param {String} adgroupId
         * @returns {BEM.MODEL}
         */
        getChildGroupById: function(adgroupId) {
            return BEM.MODEL.getOrCreate({ name: this.getChildGroupModelName(), id: adgroupId });
        },

        isOffTab: function() {
            return this.get('currentTab') === 'off';
        },
        isArchiveTab: function() {
            return this.get('currentTab') === 'arch';
        },

        isStopOnContext: function() {
            return this.get('dontShowYacontext') == 'Yes';
        }
    });
})();
