//Динамический креатив. Не является объявлением в директе, объявление в директе - dm-dynamic-media-banner
BEM.MODEL.decl('dm-dynamic-media-creative', {
    /**
     * id креатива
     */
    creative_id: 'id',

    /**
     * название - заголовок
     */
    name: 'string',

    /**
     * ширина изображения
     */
    width: 'number',

    /**
     * высота изображения
     */
    height: 'number',

    /**
     * коэффициент масштабирования изображения для показа в интерфейсе
     */
    preview_scale: 'number',

    /**
     * альтернативный текст
     */
    alt_text: 'string',

    /**
     * ссылка
     */
    href: 'string',

    /**
     * кол-во показов
     */
    shows: 'number',

    /**
     * превью изображения
     */
    preview_url: 'string',

    /**
     * id клиента
     */
    ClientID: 'string',

    /**
     * статус-состояние креатива
     */
    status_moderate: 'string',

    /**
     * список кампаний использующих креатив
     */
    used_in_camps: {
        type: 'models-list',
        modelName: 'dm-dynamic-media-creative-campaign'
    },

    /**
     * Тип баннера
     */
    bs_template_name: 'string',

    /**
     * Регионы показа
     */
    geo_names: 'string',

    /**
     * список причин отклонения на модерации
     */
    rejection_reason_ids: {
        type: 'array'
    },

    // тэг размерности креатива: ширина X высота
    sizeTag: {
        type: 'string',
        dependsFrom: ['width', 'height'],
        calculate: function(fields) {
            return fields.width + 'x' + fields.height;
        }
    },

    /**
     * Тип бизнеса к которому относится креатив
     */
    business_type: 'string'

});
