BEM.MODEL.decl({ name: 'dm-dynamic-media-feed', baseModel: 'dm-feed' }, {

    last_refreshed: 'string',

    refresh_interval: 'number',

    client_id: 'number',

    email: 'string',

    categories: {
        type: 'models-list',
        modelName: 'dm-dynamic-media-feed-category'
    },

    update_status: 'string'

}, {

    /**
     * Запрашивает данные от сервера
     * @param {Object} [feedsParams]
     * @param {Array} [feedsParams.selectedItems] - список выбранных категорий
     * @param {String} [feedsParams.adgroupIds] - номера групп
     * @return {$.Deferred}
     * @private
     */
    fetch: function(feedsParams) {
        feedsParams || (feedsParams = {});

        var promise = $.Deferred(),
            params = {
                cmd: 'ajaxGetFeeds',
                ulogin: u.consts('ulogin'),
                page: 1,
                count: 1,
                with_categories: 1,
                search: this.get('feed_id'),

                // DIRECT-57573: Не отправлять на клиент категории с флагом is_deleted=true
                // исключение составляют категории которые выбраны, выбранные id категорий ханятся в selectedItems
                selected_categories: feedsParams.selectedItems ? feedsParams.selectedItems.join(',') : '',
                adgroup_ids: feedsParams.adgroupIds
            },
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                cache: false,
                type: 'POST',
                dataType: 'json'
            });

        request.get(params, function(response) {
            var items,
                fields,
                result = {
                    categories: []
                };

            // если не пришло ни ответа ни привета, считаем ошибкой
            !(response.result || response.error) && (response = { error: { message: 'No Answer Error' } });

            if (response.error) {
                promise.reject(new Error(response.error.message));
            } else {
                items = response.result.items[0];
                fields = u._.filter(Object.keys(this.fieldsDecl), function(field) {
                    return field !== 'categories';
                });

                this.update(u._.pick(items, fields));

                u._.extend(result, this.toJSON());

                u.forEachByChunks(items.categories, {
                    delay: 0,
                    size: 150
                }, function(category) {
                    result.categories.push(this.get('categories').add(category).toJSON());
                }, this)
                    .start()
                    .then(function() {
                        promise.resolve(result);
                    });
            }

        }.bind(this));

        return promise;
    }

});
