BEM.MODEL.decl({ model: 'dm-dynamic-media-group', baseModel: 'dm-base-group-with-feeds' }, {
    // Id модели и группы , именно string так как новая группа имеет id new1
    modelId: 'id',

    // id родительской кампании
    cid: 'string',

    // Происходит копирование группы
    is_group_copy_action: 'boolean',

    // Имя группы объявлений
    group_name: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-media-group', 'neobhodimo-ukazat-nazvanie-gruppy', 'Необходимо указать название группы')
                },
                maxLength: {
                    value: 1024,
                    text: iget2('dm-dynamic-media-group', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 1024
                    }),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // Параметры ссылок
    href_params: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: 1024,
                    text: iget2('dm-dynamic-media-group', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 1024
                    }),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // объявления группы
    banners: {
        type: 'models-list',
        modelName: 'dm-dynamic-media-banner',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-dynamic-media-group', 'dobavte-v-gruppu-bannery', 'Добавьте в группу баннеры'),
                    validate: function() {
                        return !!this.get('banners').length()
                    }
                }
            }
        }
    },

    // Результат модерации списка фраз и гео (условия показа)
    status_moderate: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sent',
            'Sending',
            'Ready',
            'New'
        ]
    },

    tags: { type: 'models-list', modelName: 'm-group-tag' },

    //Идентификаторы креативов, которые используются в группе
    used_creative_ids: 'array',

    //Идентификаторы креативов, которые используются в группе, но не присутствуют в текущих баннерах
    otherCreativeIds: 'array',

    /* копипаста из m-group  */
    isSingleGroup: { type: 'boolean' },
    //идет копирование группы
    isCopyGroup: { type: 'boolean' },
    newGroupIndex: { type: 'number' },
    isNewGroup: { type: 'boolean' },
    adgroup_type: {
        type: 'string',
        default: 'performance'
    },
    autobudget: 'string',
    page: { type: 'number', default: 1 },

    //группа находится в архивной кампании
    is_camp_archived: 'number',

    isBannersEditable: 'boolean',

    //в превью группы есть контролы
    isPreviewHasControls: { type: 'boolean', internal: true },
    // поле для старого превью баннеров
    bannersIds: {
        type: 'array',
        internal: true,
        dependsFrom: 'banners',
        calculate: function() {
            return this.get('banners').map(function(banner) {
                return '' + banner.get('bid');
            });
        }
    },

    feedFieldForName: {
        type: 'model',
        modelName: 'dm-feed-field-for-name',
        validation: {
            rules: {
                required: {
                    text: iget2(
                        'dm-dynamic-group',
                        'feed-field-for-name-required-validation-text',
                        'Необходимо указать параметр фида'),
                    validate: function(val) {
                        return val.get('value') !== '';
                    },
                    needToValidate: function(val) {
                        return val.get('isChecked');
                    }
                }
            }
        }
    },

    feedFieldForBody: {
        type: 'model',
        modelName: 'dm-feed-field-for-body',
        validation: {
            rules: {
                required: {
                    text: iget2(
                        'dm-dynamic-group',
                        'feed-field-for-name-required-validation-text',
                        'Необходимо указать параметр фида'),
                    validate: function(val) {
                        return val.get('value') !== '';
                    },
                    needToValidate: function(val) {
                        return val.get('isChecked');
                    }
                }
            }
        }
    }
}, {

    /**
     * Возвращает данные в формате, пригодном для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON(),
            geoModel = BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });

        data.banners = this.get('banners').map(function(bannerModel, i) {
            return bannerModel.provideData();
        });
        data.performance_filters = (this.get('feed_filters') || []).map(function(filter) {
            return filter.provideData();
        });

        delete data.feed_filters;

        data.tags = this.get('tags').map(function(tag) { return tag.get('value'); });

        data.geo = geoModel.get('geo');

        data.hierarchical_multipliers = this.getMultipliersData();

        data.is_group_copy_action = data.is_group_copy_action ? 1 : 0;

        if (data.feedFieldForName.isChecked) {
            data.field_to_use_as_name = data.feedFieldForName.value;
        } else {
            data.field_to_use_as_name = ''
        }

        if (data.feedFieldForBody.isChecked) {
            data.field_to_use_as_body = data.feedFieldForBody.value;
        } else {
            data.field_to_use_as_body = ''
        }

        return data;
    },

    getMultipliersData: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
    },

    getBanners: function() {
        return this.get('banners', 'raw');
    },

    addBanner: function(creativeData) {
        var newBanners = this.getBanners().filter(function(model) {
                return model.get('isNewBanner');
            }),
            newBannerIndex = newBanners.length ?
                +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                1,
            newBannerId = 'new' + newBannerIndex,
            bannerData = {
                newBannerIndex: newBannerIndex,
                modelId: newBannerId,
                hasCopyFromPrev: true,
                creative: creativeData,
                isNewBanner: true
            };

        return this.get('banners').add(bannerData);
    },

    /**
     * Удаляет объявление с указанным идентификатором
     * @param {String} bid
     * @throws {String}
     */
    removeBanner: function(bid) {
        var banner = this.get('banners').getById(bid);

        if (!banner) {
            throw new Error('banner with bid = ' + bid + ' does not belong to this group');
        }

        banner.destruct();
    },

    /**
     * Возвращает модель региона для данной группы
     * @returns {BEM.MODEL}
     */
    getGeoModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('cid'), parentModel: this });
    },

    getRetargetingsData: function() {
        return [];
    },

    getPhrases: function() {
        return [];
    },

    getPhrasesData: function() {
        return [];
    },

    getRetargetingsModels: function() {
        return [];
    },

    getPhrasesModels: function() {
        return [];
    },

    /**
     * Преобразовывает серверные данные по баннеру в модельные
     * @param {Object} data
     * @returns {Object}
     */
    bannerDataToModelData: function(data) {
        return u['dm-dynamic-media-group'].transformBannerData({
            banner: data,
            group: this.provideData(),
            contextData: {
                cid: data.cid
            }
        });
    },

    /**
     * Преобразовывает серверные данные по группе в модельные (включая баннеры)
     * @param {Object} data
     * @returns {Object}
     */
    dataToModelData: function(data) {
        return u['dm-dynamic-media-group'].transformData({
            group: data
        });
    },

    /**
     * Возвращает идентификаторы креативов, которые используются в группе
     * Сюда включены как креативы объявлений, которых нет на клиенте, так и текущие набранные
     * @returns {Number[]}
     */
    getUsedCreativeIds: function() {
        var groupCreatives = this.get('otherCreativeIds'),
            bannerCreatives = this.get('banners').map(function(banner) {
                return banner.get('creative').get('creative_id');
            });

        return u._.union(groupCreatives, bannerCreatives);
    }
});
