BEM.MODEL.decl({ name: 'dm-feed-filter-tree-condition', baseModel: 'dm-feed-filter-condition' }, {
    /**
     * Копия оригинального значения поля
     * Используется для актуализации значения при изменении набора категорий фида
     */
    originValue: 'string'
}, {
    /**
     * Возвращает исходное значение условия
     * Исходным считаем значение на момент изменение фида. Пользователь может добавлять и удалять категории фильтра
     * до момента сохранения группы, смена фида происходит online и необходимо получить актуальный слепок
     * @returns {String}
     */
    getOriginValue: function() {
        !this.get('originValue') && this.set('originValue', this.get('value'));

        return this.get('originValue');
    },

    /**
     * Обновляет значение условия согласно текущему набору категорий фида
     * @param {Array} ids - список идентификаторов текущего набора категорий
     */
    rebaseCategoryTree: function(ids) {
        this.set('value', u._.intersection(ids, this.getOriginValue()));
    }
});
