BEM.MODEL.decl('dm-feed-filter', {
    //Является ли новым, то есть еще не сохраненным на сервере
    isNew: { type: 'boolean', default: true },

    // клиентский идентификатор фильтра (изначально соответствует реальному и не меняется в модели)
    filter_id: {
        default: 0,
        type: 'id'
    },

    // реальный идентификатор (меняется и должен быть использован для связи с серверными ручками)
    real_filter_id: {
        default: 0,
        type: 'number'
    },

    from_tab: {
        type: 'enum',
        default: '',
        enum: ['', 'tree', 'condition', 'all-products']
    },

    available: {
        type: 'boolean',
        default: false
    },

    adgroup_id: 'string',
    //идентификатор модели группы
    adgroupModelId: 'string',

    adgroup_type: 'string',

    filter_name: 'string',

    campaign_id: 'string',

    //@heliarian имя для фида в ДО Нужно для корректной работы в i-phrases-prices-helper
    condition_name: 'string',

    retargetings: {
        type: 'array',
        default: []
    },

    now_optimizing_by: {
        type: 'enum',
        enum: ['', 'CPC', 'CPA']
    },

    price: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currCode = this.get('currency'),
                currency = u.consts('currencies')[currCode],
                strategy = this.getStrategy(),
                needValidFlag = !strategy.is_autobudget && (!strategy.name ||
                    (strategy.name == 'different_places' && strategy.search_strategy !== 'stop'));

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2('dm-feed-filter', 'vvedeno-nekorrektnoe-znachenie-minimalnoe', 'Введено некорректное значение. Минимальное: {foo}', {
                            foo: currency.MIN_PRICE
                        }),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2('dm-feed-filter', 'ukazano-slishkom-bolshoe-znachenie', 'Указано слишком большое значение. Максимум: {foo}', {
                            foo: currency.MAX_PRICE
                        }),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                },
                needToValidate: function() {
                    return this.get('adgroup_type') == 'dynamic';
                }
            };
        }
    },

    price_context: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currCode = this.get('currency'),
                currency = u.consts('currencies')[currCode],
                strategy = this.getStrategy(),
                needValidFlag = (strategy.name == 'different_places' && !strategy.is_autobudget);

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2('dm-feed-filter', 'vvedeno-nekorrektnoe-znachenie-minimum', 'Введено некорректное значение. Минимум: {foo}', {
                            foo: currency.MIN_PRICE
                        }),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2('dm-feed-filter', 'ukazano-slishkom-bolshoe-znachenie', 'Указано слишком большое значение. Максимум: {foo}', {
                            foo: currency.MAX_PRICE
                        }),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                },
                needToValidate: function() {
                    return this.get('adgroup_type') == 'dynamic';
                }
            };
        }
    },

    price_cpc: {
        type: 'number',

        format: function(value) {
            return u.numberFormatter.format(value) || '';
        },
        preprocess: function(value) {
            // при использовании цены по умолчанию запрещено задавать значение поля
            return this.model.get('use_default_price') ? this.get() : this._preprocess(value);
        },
        validation: function() { return this.getPriceValidationRules('CPC'); }
    },

    price_cpa: {
        type: 'number',

        format: function(value) {
            return u.numberFormatter.format(value) || '';
        },
        preprocess: function(value) {
            // при использовании цены по умолчанию запрещено задавать значение поля
            return this.model.get('use_default_price') ? this.get() : this._preprocess(value);
        },
        validation: function() { return this.getPriceValidationRules('CPA'); }
    },

    condition: {
        type: 'models-list',
        modelName: 'dm-feed-filter-condition'
    },

    condition_tree: {
        type: 'models-list',
        modelName: 'dm-feed-filter-tree-condition'
    },

    target_funnel: {
        type: 'string',
        default: Object.keys(u.feedFilterData.targetAudienceTitles)[0]
    },

    has_default_price: {
        type: 'boolean',
        default: false
    },

    use_default_price: {
        type: 'boolean',
        default: false
    },

    ctx_shows: 'number',

    ctx_clicks: 'number',

    ctx_ctr: 'number',

    is_settings_editable: {
        type: 'boolean',
        default: false
    },

    is_price_editable: {
        type: 'boolean',
        default: false
    },

    is_suspended: {
        type: 'boolean',
        default: false
    },

    is_deleted: {
        type: 'boolean',
        default: false
    },

    currency: {
        type: 'string',
        calculate: function() {
            return this.getParentModel().getCurrency();
        }
    },

    price_change_restricted: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            return this.get('use_default_price') || this.get('is_suspended') || this.get('is_deleted');
        }
    },

    is_cpa: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            var strategy = this.getParentModel().getCampaignModel().get('strategy');

            return ['autobudget_avg_cpa_per_camp', 'autobudget_avg_cpa_per_filter']
                .indexOf(strategy.name || strategy.net.name) != -1;
        }
    },

    is_cpc: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            var strategy = this.getParentModel().getCampaignModel().get('strategy');

            return ['autobudget_avg_cpc_per_camp', 'autobudget_avg_cpc_per_filter']
                .indexOf(strategy.name || strategy.net.name) != -1;
        }
    },

    /**
     * Флаг, корректны ли настройки фильтра
     * В режиме таба "Условия" фильтр считается всегда корректным
     * В режиме таба "Дерево категорий" фильтр считается некорректным если список ID категорий пуст
     */
    isIncorrect: {
        type: 'boolean',
        default: false,
        dependsFrom: ['condition_tree'],
        calculate: function() {
            return this.isTreeTab() && !this.hasTreeConditionIds();
        }
    }

}, {
    /**
     * Возвращает объект правил для валидации цен
     * @returns {Object}
     */
    getPriceValidationRules: function(type) {
        var currency = this.get('currency');

        return {
            rules: {
                lte: {
                    value: u.currencies.getConst(currency, 'MIN_CPC_CPA_PERFORMANCE'),
                    text: iget2('dm-feed-filter', 'znachenie-v-pole-s', 'Значение в поле {foo} не может быть меньше {bar}', {
                        foo: type,
                        bar: u.currencies.formatConst(currency, 'MIN_CPC_CPA_PERFORMANCE')
                    }),
                    needToValidate: function(value) {
                        // для оптимизации кол-ва конверсий не надо валидировать нечисловые
                        // значения CPA/CPC, если есть ставка по умолчанию; CPA можно оставить пустым
                        if ((type == 'CPA' || this.get('has_default_price') &&
                            this.get('is_cpa')) && typeof value == 'undefined') {

                            return false;
                        }

                        return true;
                    }
                },
                gte: {
                    value: u.currencies.getConst(currency, 'MAX_PRICE'),
                    text: iget2('dm-feed-filter', 'znachenie-v-pole-s-100', 'Значение в поле {foo} не может быть больше {bar}', {
                        foo: type,
                        bar: u.currencies.formatConst(currency, 'MAX_PRICE')
                    }),
                    needToValidate: function(value) { return !isNaN(value); }
                }
            },
            needToValidate: function(value) {
                // не надо валидировать, если используем ставку по умолчанию или если фильтр в ДО
                if (this.get('use_default_price') || this.get('adgroup_type') == 'dynamic') return false;

                // не надо валидировать CPA если стратегия не оптимизация кол-ва конверсий
                if (type == 'CPA') {
                    return this.get('is_cpa');
                }

                // не надо валидировать CPC если стратегия не оптимизация кликов
                if (type == 'CPC') {
                    return this.get('is_cpc');
                }

                return false;
            }
        };
    },

    /**
     * Возвращает массив используемых связок type + kind + value вложенных целей
     */
    getConditionsState: function() {
        var tab = this.get('from_tab'),
            retargeting = u._.isEmpty(this.get('retargetings')) ? '' : this.get('retargetings')[0].ret_cond_id,
            states = [];

        if (tab == 'all-products') {
            states.push(this.get('target_funnel') + retargeting);
        } else {
            var conditions = this.get(this._getConditionKey());

            conditions.forEach(function(model) {
                states.push(this.get('target_funnel') + model.getStateString() + retargeting);
            }, this);
        }

        return states;
    },

    /**
     * Возвращает подготовленные данные модели для сохранения
     * @returns {Object}
     */
    provideData: function() {
        var modelData = this.toJSON(),
            result = u._.pick(modelData, [
                'filter_name',
                'target_funnel',
                'filter_id',
                'name',
                'from_tab',
                'is_suspended',
                'available',
                'is_deleted'
            ]);

        u._.extend(result, this._getPricesData(), {
            condition: modelData[this._getConditionKey()].filter(function(cond) {
                //в dm-dynamic-media-group transformData() в condition_tree были добавлены пустые значения для price и vendor - их нужно отфильтровать
                return cond.value && cond.value.length;
            }).map(function(cond) {
                //сервер ждет отношение exists в виде строки 1, а мы все value на клиенте храним в массиве
                if (cond.relation === 'exists') cond.value = cond.value[0];

                return cond;
            }),
            retargeting: modelData.retargetings.length ?
                modelData.retargetings.map(function(retargetingData) {
                    var res = u._.pick(retargetingData, [
                        'condition_name',
                        'condition_desc',
                        'ret_cond_id',
                        'is_accessible'
                    ]);

                    res.condition = retargetingData.groups;

                    return res;
                })[0] :
                null,
            available: result.available === true ? 1 : 0,
            filter_id: this.get('isNew') || /new-feed-filter/.test(modelData.filter_id) ?
                '' :
                result.filter_id
        });

        //todo DIRECT-54675 @heliarian - на сервере будет задача как сведения perfomance_filters и dynamic_filters
        //todo к единому feed_filters, и perf_filter_id и dyn_id к filter_id номер задачи скажет  hrustyashko как выйдет из отпуска
        if (modelData.adgroup_type == 'dynamic') {
            result.condition_name = result.filter_name;
            result.dyn_id = result.filter_id;
        } else {
            result.perf_filter_id = result.filter_id;
        }

        return result;
    },

    /**
     * Возвращает объект с данными цен
     * @returns {Object}
     */
    _getPricesData: function() {
        if (this.get('adgroup_type') == 'dynamic') {
            var strategy = this.getStrategy();

            return [
                !strategy.is_autobudget &&
                    (!strategy.name || (strategy.name == 'different_places' && strategy.search_strategy !== 'stop')) &&
                        'price',
                strategy.name == 'different_places' && !strategy.is_autobudget && 'price_context'
            ].reduce(function(result, name) {
                result[name] = this.get(name);

                return result;
            }.bind(this), {})

        } else {
            return (this.get('is_cpa') ? ['price_cpa'] : ['price_cpc']).reduce(function(result, name) {
                result[name] = (this.get('use_default_price') || !this.get(name)) ? 0 : this.get(name);

                return result;
            }.bind(this), {});
        }

    },

    /**
     * Возвращает данные текущей стратегии
     * @returns {Object}
     */
    getStrategy: function() {
        return this.getParentModel().getStrategy();
    },

    /**
     * Возвращает код валюты
     * @returns {String}
     */
    getCurrency: function() {
        return this.getParentModel().getCurrency();
    },

    /**
     * Возвращает флаг является ли текущим таб "Дерево категорий"
     * @returns {Boolean}
     */
    isTreeTab: function() {
        return this.get('from_tab') == 'tree';
    },

    /**
     * Возвращает флаг наличия хотя бы одного id в дереве категорий
     * @returns {Boolean}
     */
    hasTreeConditionIds: function() {
        var tree = this.get('condition_tree'),
            condition = tree.where({ field: 'categoryId' })[0];

        return !tree.length() || (condition && !!condition.get('value') && !!condition.get('value').length);
    },

    /**
     * Обновляет значение условия фильтров согласно текущему набору категорий фида
     * @param {Array} ids - список идентификаторов текущего набора категорий
     */
    rebaseConditions: function(ids) {
        this.isTreeTab() && this.get('condition_tree').where({ field: 'categoryId' }).forEach(function(condition) {
            condition.rebaseCategoryTree(ids)
        });
    },

    /**
     * Обновляет модель из объекта новых данных
     * @param {Object} data объект с новыми данными
     */
    updateFromData: function(data) {
        this.update(u._.pick(data, u._.without(Object.keys(data), 'condition', 'condition_tree')));

        this._updateConditions(data);
    },

    /**
     * Возвращает актуальное название поля условий в зависимости от значения from_tab
     * @returns {String}
     * @private
     */
    _getConditionKey: function() {
        return this.get('from_tab') == 'tree' ? 'condition_tree' : 'condition';
    },

    /**
     * Обновляет поле условий в зависимости от значения from_tab
     * Обновление происходит только в том случаем, если есть различие между наборами,
     * это позволяет избежать ложного срабатывания события change
     * @param {Object} data объект с новыми данными
     * @private
     */
    _updateConditions: function(data) {
        var key = this._getConditionKey(),
            src = this.toJSON();

        !u._.isEqual(src[key], data[key]) && this.set(key, data[key]);
    },

    /**
     * Устанавливает диапазон цен для вкладки "Дерево категорий"
     * @param {Object} price
     * @param {String[]} price.value
     * @param {String} price.relation
     * @param {String} price.field
     */
    setPrice: function(price) {
        var conditionTree,
            priceCondModel;

        if (this.get('from_tab') == 'tree') {
            conditionTree = this.get('condition_tree');

            priceCondModel = conditionTree.filter(function(model) {
                return model.get('field') == 'price';
            })[0];

            if (priceCondModel) {
                priceCondModel.set('value', price.value);
            } else {
                conditionTree.add(price);
            }
        }
    },

    /**
     * Удаляет диапазон цен для вкладки "Дерево категорий", если он был установлен
     */
    clearPrice: function() {
        var conditionTree,
            priceCondModel;

        if (this.get('from_tab') == 'tree') {
            conditionTree = this.get('condition_tree');

            priceCondModel = conditionTree.filter(function(model) {
                return model.get('field') == 'price';
            })[0];

            priceCondModel && conditionTree.remove(priceCondModel.id);
        }
    },

    /**
     * Устанавливает категории на вкладке "Дерево категорий"
     * @param {String[]} categoriesIds
     */
    setCategoriesIds: function(categoriesIds) {
        var conditionTree,
            categoryCondModel;

        if (this.get('from_tab') == 'tree') {
            conditionTree = this.get('condition_tree');

            categoryCondModel = conditionTree.filter(function(model) {
                return model.get('field') == 'categoryId';
            })[0];

            if (categoryCondModel) {
                categoryCondModel.set('value', categoriesIds);
            } else {
                conditionTree.add({
                    field: 'categoryId',
                    relation: '==',
                    value: categoriesIds
                });
            }
        }

    },

    /**
     * Устанавливает галку "только в наличии" для таба "Дерево категории"
     * @param {Boolean} available
     */
    setAvailable: function(available) {
        if (this.get('from_tab') == 'tree') {
            this.set('available', available);
        }
    }
});
