u.register({

    'dm-feed-filter': {

        /**
         *
         * @param {Object} options
         * @param {Array} options.feedFilters
         * @param {String} options.adgroupType
         * @param {String} options.adgroupId
         */
        transformData: function(options) {
            var adgroupType = options.adgroupType,
                adgroupId = options.adgroupId,
                feedFilters = options.feedFilters;

            return feedFilters.map(function(filter) {
                var groupedConditions = u._.groupBy(filter.condition, 'field'),
                    conditions = [];

                // Выяснил в ходе разговора с менеджером что данные поля доступны для фидов типа YandexMarket
                // у остальных типов нет дерева
                if (filter.filter_type.match(/_YandexMarket$/)) {
                    conditions = ['categoryId', 'price', 'vendor'].map(function(field) {
                        return groupedConditions[field] ?
                            groupedConditions[field][0] :
                            {
                                field: field,
                                value: '',
                                relation: field == 'price' ? '<->' : field == 'vendor' ? 'ilike' : '=='
                            };
                    });
                }

                //@heliarian для динамических баннеров и для смарт-баннеров параметры фильтров по фиду приходят в разных переменных
                if (adgroupType == 'dynamic') {
                    // todo DIRECT-54675 @alkaline рефакторинг после сведения perfomance_filters и dynamic_filters к единому формату
                    // Сейчас с бекэнда при копировании приходит filter_id и не приходит dyn_id чтобы можно было понять что сущность новая,
                    // но иметь при этом идентификаторы фильтров, потому что они ожидаются в блоке, отрисовывающем изменени/удаление
                    filter.real_filter_id = filter.filter_id = filter.filter_id || filter.dyn_id;
                    filter.filter_name = filter.condition_name;
                    filter.retargetings = [];
                } else {
                    filter.filter_id = filter.perf_filter_id;
                    filter.real_filter_id = filter.perf_filter_id;

                    // всё, что не больше нуля, не ставка
                    filter.price_cpc > 0 || (filter.price_cpc = null);
                    filter.price_cpa > 0 || (filter.price_cpa = null);
                    filter.retargetings = filter.retargeting ? [filter.retargeting] : [];
                }

                filter.is_suspended = !!+filter.is_suspended;
                filter.is_deleted = !!+filter.is_deleted;
                filter.condition_tree = conditions;
                filter.adgroupModelId = adgroupId;
                filter.adgroup_id = adgroupId;
                filter.adgroup_type = adgroupType;

                //сервер присылает отношение exists в виде строки 1, а мы все value на клиенте храним в массиве
                filter.condition = filter.condition.map(function(cond) {
                    if (cond.relation === 'exists') { cond.value = [cond.value]; }
                    return cond;
                });

                return filter;
            });
        }

    }

});
