BEM.MODEL.decl('dm-feed-history', {

    // фид
    feed: {
        type: 'model',
        modelName: 'dm-feed'
    },

    // список фидов
    feed_history: {
        type: 'models-list',
        modelName: 'dm-feed-timeline'
    },

    // полное количество фидов
    total_count: {
        type: 'number',
        default: 0
    }

}, {

    /**
     * Запрашивает данные от сервера и обновляет DM
     * @param {Number} feedId идентификатор фида
     * @param {Number} page страница выборки
     * @param {Number} count количество элементов в выборке
     * @return {$.Deferred}
     */
    syncFromServer: function(feedId, page, count) {
        var promise = $.Deferred();

        this._fetch(feedId, page, count).then(function(data) {
            this.update(u._.pick(data, ['feed', 'feed_history', 'total_count']));

            promise.resolve();
        }.bind(this));

        return promise;
    },

    /**
     * Запрашивает данные от сервера
     * @param {Number} feedId идентификатор фида
     * @param {Number} page страница выборки
     * @param {Number} count количество элементов в выборке
     * @return {$.Deferred}
     * @private
     */
    _fetch: function(feedId, page, count) {
        var promise = $.Deferred(),
            params = {
                cmd: 'ajaxGetFeedHistory',
                ulogin: u.consts('ulogin'),
                feed_id: feedId,
                page: page,
                count: count
            },
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                cache: false,
                dataType: 'json'
            });

        request.get(params, function(response) {
            // если не пришло ни ответа ни привета, считаем ошибкой
            !(response.result || response.error) && (response = { error: { message: 'No Answer Error' } });

            response.error ?
                promise.reject(new Error(response.error.message)) :
                promise.resolve(response.result);
        });

        return promise;
    }

});
