BEM.MODEL.decl('dm-feed-list', {

    // список фидов
    items: {
        type: 'models-list',
        modelName: 'dm-feed'
    },

    // полное количество фидов
    total_count: {
        type: 'number',
        default: 0
    }

}, {

    /**
     * Запрашивает данные от сервера и обновляет DM
     * @param {Number} page страница выборки
     * @param {Number} count количество элементов в выборке
     * @param {String} [sort] поле сортировки
     * @param {Number} [reverse] флаг направления сортировки (1 или 0)
     * @param {String} [search] текст для поиска фида по названию или/и идентификатору
     * @return {$.Deferred}
     */
    fetch: function(page, count, sort, reverse, search) {
        var dna = window.dna;

        if (!dna) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        var deferred = $.Deferred(),
            queryExecutor = dna.utils.getQueryExecutor(u.consts('ulogin'));

        queryExecutor.getFeedsFromOldInterface(u.consts('ulogin'), {
            page: page,
            count: count,
            sort: sort,
            reverse: reverse,
            search: search
        })
            .then(function(res) {
                if (!res.success) {
                    deferred.reject(new Error());
                } else {
                    deferred.resolve(u.mapFeedFromDNAApi(res));
                }
            })
            .catch(function() {
                deferred.reject(new Error());
            })

        return deferred.promise().done(this.update.bind(this));
    },

    /**
     * Удаляет данные через запрос к серверу и обновляет модель, убирая из неё успешно удалённые элементы
     * @param {Number[]} idsList
     * @return {$.Deferred}
     * @private
     */
    remove: function(idsList) {
        var dna = window.dna;

        if (!dna) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        var deferred = $.Deferred(),
            apiManager = dna.utils.getRestApiManager();

        apiManager.deleteFeed(u.consts('ulogin'), idsList)
            .then(function(res) {
                if (!res.success) {
                    deferred.reject(new Error());
                } else {
                    deferred.resolve(res.result);
                }
            }.bind(this))
            .catch(function() {
                deferred.reject(new Error());
            });

        return deferred.promise().done(function(data) {
            var items = this.get('items');

            data.forEach(function(id) {
                items.remove(+id);

                this.set('total_count', this.get('total_count') - 1);
            }, this);
        }.bind(this));
    }

});
