BEM.MODEL.decl('dm-feed', {

    // идентификатор фида
    feed_id: 'id',

    // название фида
    name: 'string',

    // тип фида
    feed_type: {
        type: 'enum',
        enum: u.feedData.feedType,
        default: u.feedData.defaultFeedType
    },

    // тип бизнеса фида
    business_type: {
        type: 'enum',
        enum: u.feedData.businessType,
        default: u.feedData.defaultBusinessType
    },

    // дата последнего изменения вида 2014-01-01 01:01:01
    last_change: 'string',

    // имя файла фида
    filename: 'string',

    // источник файла фида
    source: {
        type: 'enum',
        enum: u.feedData.source
    },

    // url файла фида
    url: 'string',

    // логин
    login: 'string',

    // наличие пароля
    hasPassword: 'boolean',

    isReadOnly: 'boolean',

    // элементы фида
    offers_count: 'number',

    // количество ошибок при скачивании файла по ссылке
    fetch_errors_count: 'number',

    // количество ошибок парсинга
    errors_count: 'number',

    // количество предупреждений при парсинге
    warnings_count: 'number',

    // статус фида
    display_status: {
        type: 'enum',
        enum: u.feedData.status
    },

    // показатель требования автоматически удалять UTM-метки
    is_remove_utm: {
        type: 'enum',
        enum: ['1', '0']
    },

    // список кампаний, в которых используется фид
    campaigns: {
        type: 'models-list',
        modelName: 'dm-feed-campaign'
    }

});
