BEM.MODEL.decl({ model: 'dm-internal-free-campaign', baseModel: 'dm-base-campaign' }, {

    // Таргетинг на устройства (данные о выбранных устройствах)
    device_targeting: 'string',

    // Дополнительные счетчики Метрики
    metrika_counters: 'string',

    // Включена ли разметка ссылок для метрики
    status_click_track: 'boolean',

    // 2й шаг, создание новой кампании
    isCreatingNewCamp: 'boolean',

    // Останавливать объявления при неработающем сайте
    statusMetricaControl: 'flag',

    // Внешняя интернет-статистика (метка «_openstat» на ссылках)
    statusOpenStat: 'flag',

    // Максимальное количество ключевых фраз на группу
    maxKeywordLimit: 'number',

    // Флаг говорит о том, что опция "Расширенный географический таргетинг" отключена
    no_extended_geotargeting: {
        type: 'enum',
        enum: [0, 1]
    },

    // количество показов в ограничении частоты показов
    rf: 'number',

    // количество дней в ограничении частоты показов ( = 0 если за весь период размещения)
    rfReset: 'number',

    // ключевые цели метрики (DIRECT-73912)
    meaningful_goals: 'array',

    // счетчики используемые в экспериментах
    counters_in_experiments: 'object',

    // получение выбранного охвата стратегии
    strategy_cpm_auto_coverage: 'string',

    // pageId (идентификаторы страниц сайтов), на которых указывается рекламная кампания
    allowed_page_ids: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('allowPageIdsLimit'),
                    text: u.pluralForms(
                        iget2(
                            'dm-internal-free-campaign',
                            'error-message-max-length',
                            'Превышена максимальная длина строки, {maxLength} {символ|символа|символов}.',
                            { maxLength: u.consts('allowPageIdsLimit') }
                        ),
                        u.consts('allowPageIdsLimit')
                    ),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // запрещенные площадки для показа видео объявлений
    disabled_video_placements: 'array',

    restriction_type: {
        type: 'enum',
        enum: ['shows', 'clicks', 'days'],
        default: 'days'
    },
    restriction_value: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-internal-distrib-campaign', 'error-message-required-restriction-value', 'Укажите значение ограничения'),
                    validate: function(val) {
                        var value = Number(val);

                        // Целые числа больше нуля
                        return String(value) === val && value % 1 === 0 && value > 0 ;
                    }
                }
            }
        }
    },
    restriction_value_by_type: {
        internal: true,
        type: 'string',
        dependsFrom: ['restriction_type', 'restriction_value'],
        calculate: function() {
            if (this.get('restriction_type') === 'days') {
                return this.get('restriction_value') || '100000';
            }

            return '';
        }
    },
    is_mobile: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-internal-distrib-campaign', 'error-message-required-is-mobile', 'Сделайте выбор'),
                    validate: function(val) {
                        return ['0', '1'].indexOf(val) > -1;
                    }
                }
            }
        }
    },
    place_id: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-internal-distrib-campaign', 'error-message-required-place-id', 'Не передано обязательное поле \'Place id\''),
                    validate: function(val) {
                        // значение в выпадашке должно быть выбрано непустое, а в остальном достаточно серверной вылидации,
                        // потому что сервер же и дал нам содержимое этой выпадашки
                        return val !== '' && val !== '0';
                    }
                }
            }
        }
    },
    page_ids: {
        type: 'string',
        validation: {
            rules: {
                format: {
                    text: iget2('dm-internal-distrib-campaign', 'error-message-page-ids-format', 'Значение поля должно быть списком чисел через запятую'),
                    validate: function(val) {
                        if (!val) {
                            return true;
                        }

                        // Без пробелов
                        return val.split(' ').length < 2 && val.split(',').every(function(v) {
                            var value = Number(v);

                            // Целые числа больше нуля
                            return String(value) === v && value % 1 === 0 && value > 0 ;
                        });
                    }
                }
            }
        }
    }
});
