BEM.MODEL.decl({ model: 'dm-mobile-content-banner', baseModel: 'dm-base-banner' }, {

    //--- используется в b-banner-status
    //@heliarian - нужно ли реально в модели - не ясно
    phoneflag: 'string',
    statusMetricaStop: 'string',
    declined_show: 'boolean',
    //---

    //@heliarian - нужно ли реально в модели - не ясно
    geo_id: 'string',

    // Заголовок баннера
    title: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('dm-mobile-content-banner', 'neobhodimo-ukazat-zagolovok', 'Необходимо указать заголовок') },
                noLongWords: {
                    validate: function(val) {
                        // Увеличение лимита на 1 требуется чтобы слово длинной 22 символа было валидным
                        // т.к. регулярное выражение подразумевает логику >=
                        var maxUniLength = u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH') + 1;

                        return !(new RegExp('[а-яА-ЯёЁA-Za-z0-9_]{' + maxUniLength + ',}').test(val));
                    },
                    text: function(val) {
                        return u.pluralForms(
                            iget2(
                                'dm-mobile-content-banner',
                                'v-pole-zagolovok-nedopustimy',
                                'В поле "Заголовок" недопустимы слова длиной более {foo} {знака|знаков|знаков}: «{bar}».',
                                {
                                    foo: u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH'),
                                    bar: val
                                }
                            ),
                            u.consts('MAX_TITLE_UNINTERRUPTED_LENGTH'));
                    }
                },
                tooLong: {
                    validate: function(val) {
                        return u.preview.skipSharpSign(val).length <= u.consts('rights').increase_ad_text_limits ? u.consts('NEW_MAX_TITLE_LENGTH_MOBILE') : u.consts('MAX_TITLE_LENGTH_MOBILE');
                    },
                    text: function() {
                        return iget2('dm-mobile-content-banner', 'prevyshena-dopustimaya-dlina-zagolovka', 'Превышена допустимая длина заголовка в {text}', {
                            text: u.pluralize([
                                iget2('dm-mobile-content-banner', 'simvol', 'символ'),
                                iget2('dm-mobile-content-banner', 'simvola', 'символа'),
                                iget2('dm-mobile-content-banner', 'simvolov', 'символов'),
                                iget2('dm-mobile-content-banner', 'simvolov', 'символов')
                            ], u.consts('NEW_MAX_TITLE_LENGTH_MOBILE'))
                        });
                    }
                },
                noInvalidSymbols: {
                    validate: function(val) {
                        // eslint-disable-next-line max-len
                        return !(new RegExp('[^' + u.consts('ALLOW_BANNER_LETTERS').replace(/\\/g, '').replace(/[.?*+^$[\]\\(){}|-]/g, '\\$&') + '\\\\]').test(val));
                    },
                    text: iget2(
                        'dm-mobile-content-banner',
                        'v-pole-zagolovok-mozhno',
                        'В поле "Заголовок" можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                    )
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        },
        format: u.preview.prettifyText
    },

    // Текст баннера
    body: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('dm-mobile-content-banner', 'neobhodimo-ukazat-tekst-obyavleniya', 'Необходимо указать текст объявления') },
                noLongWords: {
                    validate: function(val) {
                        // Увеличение лимита на 1 требуется чтобы слово длинной 23 символа было валидным
                        // т.к. регулярное выражение подразумевает логику >=
                        var maxUniLength = u.consts('MAX_BODY_UNINTERRUPTED_LENGTH') + 1;

                        return !(new RegExp('[а-яА-ЯёЁA-Za-z0-9_]{' + maxUniLength + ',}').test(val));
                    },
                    text: function(val) {
                        return u.pluralForms(
                            iget2(
                                'dm-mobile-content-banner',
                                'v-pole-tekst-obyavleniya',
                                'В поле "Текст объявления" недопустимы слова длиной более {foo} {знака|знаков|знаков}: «{bar}».',
                                {
                                    foo: u.consts('MAX_BODY_UNINTERRUPTED_LENGTH'),
                                    bar: val
                                }
                            ),
                            u.consts('MAX_BODY_UNINTERRUPTED_LENGTH'));
                    }
                },
                tooLong: {
                    validate: function(val) {
                        return u.preview.skipSharpSign(val).length <= u.consts('MAX_BODY_LENGTH_MOBILE');
                    },
                    text: iget2('dm-mobile-content-banner', 'prevyshena-dopustimaya-dlina-teksta', 'Превышена допустимая длина текста в {text}', {
                        text: u.pluralize([
                            iget2('dm-mobile-content-banner', 'simvol', 'символ'),
                            iget2('dm-mobile-content-banner', 'simvola', 'символа'),
                            iget2('dm-mobile-content-banner', 'simvolov', 'символов'),
                            iget2('dm-mobile-content-banner', 'simvolov', 'символов')
                        ], u.consts('MAX_BODY_LENGTH_MOBILE'))
                    })
                },
                noInvalidSymbols: {
                    validate: function(val) {
                        // eslint-disable-next-line max-len
                        return !(new RegExp('[^' + u.consts('ALLOW_BANNER_LETTERS').replace(/\\/g, '').replace(/[.?*+^$[\]\\(){}|-]/g, '\\$&') + '\\\\]').test(val));
                    },
                    text: iget2(
                        'dm-mobile-content-banner',
                        'v-pole-tekst-obyavleniya-101',
                        'В поле "Текст объявления" можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                    )
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        },
        format: u.preview.prettifyText,
        preprocess: function(value) {
            return typeof value === 'string' ? value.replace('\n', ' ') : value;
        }
    },

    // Список атрибутов приложения, которые отображаются в баннере
    // возможные значения 'rating', 'price', 'icon', 'rating_votes'
    reflected_attrs: { type: 'array' },

    // действие на кнопке в баннере
    primary_action: {
        type: 'string',
        default: 'download'
    },

    // Протокол ссылки для отслеживания
    url_protocol: {
        type: 'enum',
        enum: ['http://', 'https://'],
        default: 'https://',
        calculate: function() {
            return u.getUrlProtocol(this.get('href')) || 'https://';
        },
        dependsFrom: ['href']
    },

    // Часть ссылки для отслеживания без протокола
    href: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('dm-mobile-content-banner', 'url-required-text-installs', 'Поле обязательно для заполнения'),
                    needToValidate: function() {
                        return this.getGroup().get('mobile_app_goal') === 'installs';
                    }
                },
                maxLength: {
                    value: 1024,
                    text: iget2('dm-mobile-content-banner', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 1024
                    }),
                    needToValidate: function(val) {
                        return !!val;
                    }
                },
                isUrlCorrect: {
                    text: iget2('dm-mobile-content-banner', 'nepravilnyy-format-ssylki', 'Неправильный формат ссылки'),
                    validate: function(val) {
                        return u.isUrl(val);
                    },
                    needToValidate: function(val) {
                        return !!val;
                    }
                },
                validTrackingSystem: {
                    // оборачиваем в функцию, чтобы iget не выполнился в момент декларации на сервере,
                    // т.к. метод getHelpUrl еще не зарегистрирован
                    text: function() {
                        // DIRECT-66180: 11974: Сообщение об ошибках различаются в подсказках под изображением
                        // и в сообщении об ошибках валидации
                        if (this.get('approvedTrackingSystemErrorType') === 'UnsupportedProtocol') {
                            return iget2(
                                'dm-mobile-content-banner',
                                'dannyy-domen-trekingovoy-sistemy',
                                'Данный домен трекинговой системы поддерживает только протокол https. {link}.',
                                {
                                    link: function(text) {
                                        return {
                                            block: 'b-help-link',
                                            mods: { type: 'modal', margin: 'no' },
                                            stretched: true,
                                            url: u.getHelpUrl('mobile-apps-tracking-url'),
                                            text: text
                                        };
                                    }(iget2('dm-mobile-content-banner', 'dannyy-domen-trekingovoy-sistemy-param-link', 'Разрешенные трекинговые системы')),

                                    context: 'link - Разрешенные трекинговые системы'
                                }
                            );
                        }

                        return iget2(
                            'dm-mobile-content-banner',
                            'dannyy-domen-trekingovoy-sistemy-102',
                            'Данный домен трекинговой системы не поддерживается. {link}.',
                            {
                                link: function(text) {
                                    return {
                                        block: 'b-help-link',
                                        mods: { type: 'modal', margin: 'no' },
                                        stretched: true,
                                        url: u.getHelpUrl('mobile-apps-tracking-url'),
                                        text: text
                                    };
                                }(iget2('dm-mobile-content-banner', 'dannyy-domen-trekingovoy-sistemy-102-param-link', 'Разрешенные трекинговые системы')),

                                context: 'link - Разрешенные трекинговые системы'
                            }
                        );
                    },
                    validate: function() {
                        return this.get('approvedTrackingSystem');
                    },
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        },
        preprocess: function(val) {
            if (u.validation.isUrl(val)) {
                var hrefParams = u.parseUrl(val);

                hrefParams.protocol ||
                    (val = u.formatUrl(u._.extend(hrefParams, { protocol: 'https://' })));
            }

            return val;
        }
    },

    mobileAppTrackerHref: 'string',

    approvedTrackingSystemErrorType: 'string',

    //---Модерация
    //@heliarian - неизвестно, используется ли, было скопировано из m-banner
    enable: 'string',
    //----

    // DIRECT-47806 - поля мобильного контента группы, нужны в баннере для b-banner-status
    // доступно ли в данный момент приложение
    isAvailableMobileContent: {
        type: 'boolean',
        default: false
    },

    // отвечает за отображение сообщений о статусе модерации иконки приложения
    // для группы, содержащей только графические баннеры иконка приложения показываться не будет
    // поэтому статус модерации игнорируем (DIRECT-56773)
    ignoreIconStatusModerate: 'boolean',

    // Результат модерации иконки приложения
    iconStatusModerate: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sent',
            'Sending',
            'Ready'
        ]
    },

    // хэш иконки приложения
    icon_hash: 'string',

    // Содержит ли объявление шаблон
    is_template_banner: 'boolean',

    // Ссылка с подставленным в шаблон значением
    templ_href: 'string',

    // Тело объявления с подставленным в шаблон значением
    templ_body: 'string',

    // Статус, описывающий синхронность объявления в Директе и БК.
    statusBsSynced: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sending'
        ]
    },

    // Результат модерации быстрых ссылок объявлений
    statusSitelinksModerate: {
        type: 'enum',
        enum: [
            'New'
        ]
    },

    // Флаги баннера
    flags: 'object',

    // Признак нового баннера
    isNewBanner: {
        type: 'boolean',
        default: false
    },

    newBannerIndex: 'number',

    image_model: {
        type: 'model',
        modelName: 'm-banner-pic',
        validation: {
            rules: {
                tooEarly: {
                    validate: function() {
                        return !this.get('image_model').isImageProcessing();
                    },
                    text: iget2(
                        'dm-mobile-content-banner',
                        'neobhodimo-dozhdatsya-okonchaniya-obrabotki',
                        'Необходимо дождаться окончания обработки изображения'
                    )
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'text';
            }
        }
    },

    // нужно для отрисовки предупреждений в превью на клиенте, в цепочке:
    // запрос за данными баннера -> построение модели -> отрисовка првеью
    hash_flags: { type: 'extended-object' },

    disclaimer: { type: 'string' },

    ageInstalled: { type: 'boolean', internal: true },

    // Флаг о том что трекинговая ссылка от поддерживаемых нами трекеров (DIRECT-47929)
    approvedTrackingSystem: {
        type: 'boolean',
        default: true
    },

    // данные медиа дополнений для баннера
    video_resources: {
        type: 'extended-object'
    },

    // для баннера запрещены видеодополнения по умолчанию
    disable_videomotion: {
        type: 'boolean',
        default: true
    },

    ad_type: {
        type: 'enum',
        default: 'text',
        enum: [
            'text',
            'image_ad',
            'cpc_video'
        ]
    },

    image_ad: {
        type: 'model',
        modelName: 'dm-image-ad',
        validation: {
            rules: {
                'ad-required': {
                    text: iget2('dm-mobile-content-banner', 'neobhodimo-zagruzit-kreativ', 'Необходимо загрузить креатив'),
                    validate: function() {
                        var image = this.get('image_ad'),
                            creative = this.get('creative');

                        return !!((creative && creative.get('creative_id')) || (image && image.get('hash')));
                    }
                }
            },
            needToValidate: function() {
                return this.get('ad_type') === 'image_ad' || this.get('ad_type') === 'cpc_video';
            }
        }
    },

    creative: {
        type: 'model',
        modelName: 'dm-creative'
    },

    // Размер (изображения|креатива)
    imageSize: 'string'
}, {

    /**
     * Возвращает родительскую группу баннера
     * @returns {*|BEM.MODEL|undefined}
     */
    getGroup: function() {
        var groupParams = this._path.split('.')[0].split(':');

        return BEM.MODEL.getOne({
            name: groupParams[0],
            id: groupParams[1]
        });
    },

    provideData: function() {
        var data = this.toJSON();

        //ageInstalled может быть undefined (если им не манипулировали), true или false
        if (this.get('ageInstalled') === false) {
            delete data.age;
        }

        u._.forOwn(this.get('image_model').toJSON(), function(value, key) {
            data[key] = value;
        });

        data.video_resources = u._.get(data, 'video_resources.id', null) ? data.video_resources : {};

        return data;
    }
});
