u.register({
    'dm-mobile-content-banner': {
        transformData: function(opt) {
            var banner = opt.banner,
                group = opt.group,
                campaign = opt.campaign || {},
                selectedApp = group.selected_mobile_app || campaign.selected_mobile_app,
                data = u._.pick(banner, [
                    'modelId',
                    'bid',
                    'BannerID',
                    'title',
                    'body',
                    'reflected_attrs',
                    'url_protocol',
                    'href',
                    'mobileAppTrackerHref',
                    'enable',
                    'archive',
                    'statusActive',
                    'status',
                    'declined_show',
                    'statusShow',
                    'statusAutobudgetShow',
                    'groupStatusModerate',
                    'is_template_banner',
                    'is_bs_rarely_loaded',
                    'statusPostModerate',
                    'is_edited_by_moderator',
                    'day_budget',
                    'autobudget',
                    'showModEditNotice',
                    'statusModerate',
                    'statusBsSynced',
                    'isNewBanner',
                    'flags',
                    'can_archive_banner',
                    'can_delete_banner',
                    'before_moderation',
                    'disabledAutocorrectionWarning',

                    'isAvailableMobileContent',
                    'iconStatusModerate',
                    'icon_hash',

                    'image',
                    'image_name',
                    'image_width',
                    'image_height',
                    'source_image',
                    'image_source_url',
                    'mds_group_id',

                     //todo@heliaruan - портировано из m-banner, зачем оно?
                    'statusMetricaStop',

                    'ageInstalled',

                    'banner_type',
                    'geo_id',
                    'statusSitelinksModerate',
                    'newBannerIndex',
                    'disclaimer',
                    'hash_flags',
                    'ad_type',
                    'creative',
                    'errors',
                    'image_ad',
                    'primary_action',
                    'video_resources',
                    'disable_videomotion',
                    // Нужно для b-banner-status DIRECT-79790
                    // дневной бюджет
                    'day_budget',
                    'day_budget_show_mode',
                    // дневной бюджет на основной счет
                    'wallet_day_budget',
                    'wallet_day_budget_show_mode'
                ]),
                creative = data.creative || data.image_ad;

            if (selectedApp && group.isNewGroup) {
                data.reflected_attrs = selectedApp.displayedAttributes.map(function(attr) {
                    return attr.toLowerCase();
                });

                if (selectedApp.mobileContent.age_label) {
                    data.hash_flags = {
                        age: selectedApp.mobileContent.age_label
                            .substring(0, selectedApp.mobileContent.age_label.length - 1)
                    };
                }
                data.title = selectedApp.name;
                selectedApp.trackers.length && (data.href = selectedApp.trackers[0].url);
            } else if (group.mobile_content) {
                // DIRECT-47806 - поля мобильного контента группы, нужны в баннере для b-banner-status
                data.isAvailableMobileContent = !!+group.mobile_content.is_available;
                data.ignoreIconStatusModerate = u.imageAd.groupHasOnlyCpcVideoAndImageAds(group.group_banners_types);
                data.iconStatusModerate = group.mobile_content.icon_status_moderate;
                data.icon_hash = group.mobile_content.icon_hash;
            }

            //у РМП баннера всегда есть возрастное ограничение. По дефолту - 18
            data.hash_flags = data.hash_flags || { age: '18' };

            data.age = banner.age || banner.hash_flags && banner.hash_flags.age;

            data.image_model = {
                modelId: banner.modelId,
                image: banner.image,
                image_name: banner.image_name,
                image_width: banner.image_width,
                image_height: banner.image_height,
                source_image: banner.source_image,
                image_source_url: banner.image_source_url,
                mds_group_id: banner.mds_group_id
            };

            data.adgroup_id = data.adgroup_id || group.adgroup_id;
            data.modelId = data.modelId || banner.bid;
            data.isNewBanner = !banner.bid;
            data.href = data.href || '';
            data.mobileAppTrackerHref = selectedApp && selectedApp.trackers.length && selectedApp.trackers[0].url || '';

            if (creative) {
                data.imageSize = u.imageAd.imageSizeToString(creative.width, creative.height);
            }

            return data;
        }
    }
});
