BEM.MODEL.decl({ model: 'dm-mobile-content-campaign', baseModel: 'dm-base-campaign' }, {
    //@heliarian - кажется половина этих полей тут не нужны - когда-то они были скопированы из m-campaign, но видимо устарели
    //
    campaign_goals: 'object',

    // Не учитывать автоматически остановленные объявления конкурентов
    fairAuction: 'string',

    // Включены показы по дополнительным релевантным фразам
    broad_match_flag: 'number',

    // id агентства
    agency_uid: 'number',

    // id клиента
    ClientID: 'string',

    // статус, описывающий синхронность данных уровня кампании в Директе и БК
    statusBsSynced: 'undefined',

    // На какие события отправлять смс уведомление
    sms_flags: {
        type: 'enum',
        enum: [
            '',
            'active_orders_money_out_sms',
            'active_orders_money_warning_sms',
            'moderate_result_sms',
            'notify_order_money_in_sms',
            'notify_metrica_control_sms',
            'camp_finished_sms'
        ]
    },

    // можно ли показывать кампанию по поведенческому таргетингу
    statusBehavior: 'boolean',

    // Дата последнего показа
    lastShowTime: 'string',

    //
    money_type: 'string',

    // запрещена ли оплата кампании
    statusNoPay: 'boolean',

    //
    is_camp_locked: 'number',

    //
    total_units: 'string',

    // сумма доступная для переноса средств
    sums_uni: 'object',

    // В каких блоках включена стратегия 'По минимальной цене в блоке'
    strategy_min_price: 'object',

    // всего оплачено, в юнитах (для Директа - смысла не имеет, для Баяна - показы)
    sum_units: 'string',

    //
    all_banners_num: 'string',

    // ?
    autobudget_date: 'string',

    // ?
    warnplaces_str: 'string',

    // Массив картинок на кампанию
    images: 'array',

    //
    pages_num: 'number',

    // флажок автоматически созданной заявки на оптимизацию кампании
    auto_optimize_request: {
        type: 'enum',
        enum: ['Created', 'Sended', 'No']
    },

    // Запущенность кампании
    statusShow: 'boolean',

    // Кампания оплачивалась сертификатом
    paid_by_certificate: 'boolean',

    // ?
    compaign_domains_count: 'number',

    // если значение Yes - значит создание кампании не закончено
    statusEmpty: 'boolean',

    // список почтовых уведомлений, включённых для кампании. сейчас в нём только одно уведомление
    email_notifications: 'object',

    //  потрачено на кампании, в юнитах (для Директа - смысла не имеет, для Баяна - показы)
    sum_spent_units: 'number',

    // потрачено на кампании, в валюте кампании
    sum_spent: 'number',

    // Какую сумму намеревался клиент положить на кампанию во время последнего создания счёта, в валюте кампании
    sum_to_pay: 'number',

    // расход в пределах broad_match_limit от расхода на поиске Яндекса. Указывается в процентах. от 0 до 100. -1 - неограниченно
    broad_match_limit: 'string',

    // время, когда кампания последний раз останавливалась
    stopTime: 'string',

    // с некоторой погрешностью - активна ли сейчас кампания на фронтендах БК (есть деньги, заказ включен)
    statusActive: 'boolean',

    // Есть ли у кампании группы
    has_groups: {
        type: 'enum',
        enum: [
            1,
            0
        ]
    },

    // актуальность значения autobudgetForecast
    statusAutobudgetForecast: {
        type: 'enum',
        enum: ['New', 'Valid', 'Wrong']
    },

    // принята ли кампания на пост-модерации
    statusPostModerate: {
        type: 'enum',
        enum: ['New', 'Yes', 'No', 'Accepted']
    },

    // отправка уведомлений об автоуточнении фраз по этой кампании
    sendNews: 'boolean',

    // Состояние кампании на модерации
    statusModerate: {
        type: 'enum',
        enum: ['New', 'Yes', 'No', 'Ready', 'Sending', 'Sent']
    },

    // Время последнего изменения кампании
    LastChange: 'string',

    // ?
    mediaplan_status: 'string',

    // Примечания к кампании
    camp_description: 'string',

    // pageId (идентификаторы страниц сайтов), на которых указывается рекламная кампания
    allowed_page_ids: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('allowPageIdsLimit'),
                    text: u.pluralForms(
                        iget2(
                            'dm-mobile-content-campaign',
                            'error-message-max-length',
                            'Превышена максимальная длина строки, {maxLength} {символ|символа|символов}.',
                            { maxLength: u.consts('allowPageIdsLimit') }
                        ),
                        u.consts('allowPageIdsLimit')
                    ),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // Признак того, прошла ли кампания через конвертацию валюты
    currencyConverted: 'boolean',

    // ?
    MIN_PHRASE_RANK_WARNING: 'string',

    // Время остановки кампании по дневному бюджету
    day_budget_stop_time: 'string',

    // всего оплачено, в валюте кампании
    sum: 'string',

    // Временной таргетинг, установленный на кампанию
    timeTarget: 'string',

    // клиент не желает показывать кампанию в Яндекс.Каталоге
    dontShowCatalog: 'boolean',

    // дата старта
    start_time: 'string',

    // ?
    is_search_stop: 'string',

    // ?
    warnplaces: 'number',

    // todo
    MAX_PHRASE_RANK_WARNING: 'string',

    // todo
    MAX_BANNER_LIMIT: 'string',

    // Максимальное количество ключевых фраз на кампанию
    maxKeywordLimit: 'number',

    // Оптимальное число групп для показа на странице
    optimal_groups_on_page: 'number',

    // Установленное число групп для показа на странице
    groups_on_page: 'number',

    // идентификатор агентства, ведущего кампанию, если кампания не ведётся агентством - 0
    AgencyID: 'string',

    // заархивирована ли кампания в БК
    statusBsArchived: 'boolean',

    // Тип кампании
    type: {
        type: 'enum',
        enum: ['text', 'geo', 'market', 'wallet']
    },

    // сумма последней положительной транзакции
    sum_last: 'number',

    // должна ли быть кампания удалена из базы фокусировщика
    statusYacobotDeleted: 'boolean',

    // Только для чайников! Стратегия кампании
    budget_strategy: 'string',

    // Дата окончания кампания. Значение '0000-00-00' означает, что дата не указана и показы
    finish_time: 'string',

    // Id менеджера
    manager_uid: 'number',

    // День начала кампании
    dd: 'string',

    // Месяц начала кампании
    mm: 'string',

    // Год начала кампании
    yyyy: 'string',

    // На какие типы устройств таргетировать группу
    device_type_targeting: 'array',

    // На какой тип связи таргетировать группу
    network_targeting: 'array',

    // Период времени, когда можно отправлять смс уведомления
    sms_time: 'string',

    // ежим работы дополнительных релевантных фраз (Минимальный Оптимальный Максимальный)
    broad_match_rate: {
        type: 'enum',
        enum: ['minimal', 'optimal', 'maximum']
    },

    // Заархивирована ли кампания
    is_archived: 'number',

    // Группы объявлений
    groups: 'array',

    // Всё связанное с общим счетом
    wallet: 'object',

    //@deprecated
    hasPlatformSelect: 'boolean',

    // Флаг говорит о том, что опция "Расширенный географический таргетинг" отключена
    no_extended_geotargeting: {
        type: 'enum',
        enum: [0, 1]
    },

    // Данные по счетчикам РМП
    rmpCounters: {
        type: 'model',
        modelName: 'dm-rmp-counters'
    },

    // раннее загруженные изображения для графических баннеров
    pictures: 'array',

    //---настройки на тематических площадках
    ContextLimit: 'string', //Расход удерживать в пределах
    ContextPriceCoef: 'string', //Максимальная цена клика от назначенной на поиске
    enable_cpc_hold: 'string', // удерживать цену клика на тематических площадках ниже цены клика на поиске,

    // ключевые цели метрики (DIRECT-73912)
    meaningful_goals: 'array',

    // данные выбранного приложения
    selected_mobile_app: 'object'

});
