(function() {
    var request = function(method, data) {
        var dfd = $.Deferred();

        BEM.create('i-request_type_ajax', {
            cache: false,
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this
        }).get(
                u._.extend(data, {
                    ulogin: u.consts('ulogin'),
                    adgroup_ids: this.get('adgroup_id'),
                    cid: this.getCampaignModel().get('cid')
                }),
                function(result) { result.error ? dfd.reject(result.error) : dfd.resolve(result) },
                function(err) { dfd.reject(err) },
                { type: method.toLowerCase() });

        return dfd.promise();
    };

    BEM.MODEL.decl({ model: 'dm-mobile-content-group', baseModel: 'dm-base-group' }, {
        // Ошибки на группу баннеров
        errors: 'object',

        //id первого баннера в группе
        firstBid: 'string',

        // Рекламируемое приложение
        mobile_content: {
            type: 'model',
            modelName: 'dm-mobile-content'
        },

        // состояние обновления данных по приложению
        mobile_content_updating: {
            type: 'boolean',
            internal: true
        },

        // для проверки, нужно ли запрашивать данные
        mobile_content_exist: {
            type: 'boolean',
            internal: false
        },

        // сообщение об ошибке при получении информации о приложении
        mobile_content_request_error: {
            type: 'string',
            internal: true
        },

        //у фраз в группе могут редактироваться ставки
        isBidable: { type: 'boolean', internal: true },

        // Исходная ссылка на рекламируемое приложение, которую указал рекламодатель (вместе с протоколом)
        store_content_href: {
            type: 'string',
            validation: {
                rules: {
                    required: {
                        value: true,
                        text: iget2('dm-mobile-content-group', 'ssylka-na-prilozhenie-ne', 'Ссылка на приложение не может быть пустой')
                    },
                    maxLength: {
                        value: 1024,
                        text: iget2('dm-mobile-content-group', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                            foo: 1024
                        }),
                        needToValidate: function(val) {
                            return !!val;
                        }
                    },
                    // валидирует, что есть данные по приложению (нет сообщения об ошибки получения информации)
                    contentDataRequired: {
                        text: function() {
                            return this.get('mobile_content_request_error');
                        },
                        validate: function() {
                            return !this.get('mobile_content_request_error');
                        }
                    }
                }
            }
        },

        // На какие типы устройств таргетировать группу
        device_type_targeting: 'array',

        // На какой тип связи таргетировать группу
        network_targeting: 'array',

        // Происходит копирование группы
        is_group_copy_action: 'boolean',

        // Id группы
        adgroup_id: 'string',

        //
        is_completed_group: 'boolean',

        //из кампании в баннер не прокидывается - кажется не нужен здесь
        statusOpenStat: 'string',

        //
        autobudget: 'string',

        //
        day_budget_show_mode: 'string',

        //
        autobudget_date: 'string',

        //
        camp_type: 'string',

        // Массив баннеров на странице
        banners: {
            type: 'models-list',
            modelName: 'dm-mobile-content-banner',
            validation: {
                rules: {
                    deep: true
                }
            }
        },

        // undefined
        phrases: 'array',

        has_relevance_match: {
            type: 'boolean',
            default: false
        },

        // архивная группа
        archive: {
            type: 'string',
            default: 'No'
        },

        // дата последнего обсчёта прогноза показов в bids скриптом ppcGetAdvqShowsNew.pl
        forecastDate: 'string',

        //
        cstatusModerate: 'string',

        //
        statusEmpty: 'string',

        //
        cstatusContextStop: 'string',

        //
        sum_to_pay: 'string',

        //
        auto_optimization: 'string',

        // id условия из БК, устарело l
        PriorityID: 'string',

        // Условия ретаргетинга для баннера
        retargetings: 'array',

        // Настройки интересов для группы
        target_interests: 'array',

        // Статус, описывающий синхронность группы в Директе и БК.
        statusBsSynced: {
            type: 'enum',
            enum: [
                'Yes',
                'No',
                'Sending'
            ]
        },

        // Состояние прогноза показов.
        statusShowsForecast: {
            type: 'enum',
            enum: [
                'New',
                'Processed',
                'Sending',
                'Archived'
            ]
        },

        //--- Данные по таргетингу. По идее везде должны браться из m-geo-regions
        geo: 'object',

        //todo@heliarian - не знаю зачем отдельно от geo, но везде приходит отдельно
        geo_names: 'string',
        //---

        // Номера меток, установленных на группу
        tag_ids: 'array',

        // Минус-слова на группу
        minus_words: 'array',

        //
        cstatusShow: 'string',

        //
        total_banners: 'string',

        // Не перебор ли с группами
        is_oversized: 'string',

        // минимальная версия ОС поддерживаемая приложением (задается пользователем)
        min_os_version: 'string',

        //метки на группу объявлений
        tags: { type: 'models-list', modelName: 'm-group-tag' },
        isCopyGroup: 'boolean',
        newGroupIndex: 'number',
        isNewGroup: 'boolean',

        // список ret_id условий ретаргетинга в баннере
        retargetingsIds: { type: 'array', default: [], internal: true },

        // список ret_id интересов
        interestsIds: { type: 'array', default: [], internal: true },

        // список id фраз в группе
        phrasesIds: { type: 'array', default: [], internal: true },

        new_phrases: {
            type: 'array',
            internal: true,
            validation: {
                rules: {
                    required: {
                        needToValidate: function() {
                            var retargetings = this.get('retargetingsIds'),
                                interests = this.get('target_interests'),
                                phrases = this.get('phrasesIds'),
                                relevanceMatchModel = this.getRelevanceMatchModel();

                            return (!retargetings || !retargetings.length) &&
                                (!relevanceMatchModel || relevanceMatchModel.get('bid_id') == '0') &&
                                (!this.get('has_relevance_match')) &&
                                (!interests || !interests.length) &&
                                (!phrases || !phrases.length ||
                                !phrases.filter(function(id) {
                                    return !u.isEmpty(
                                        BEM.MODEL.getOrCreate({ name: 'm-phrase-text', id: id, parentModel: this })
                                            .get('phrase')
                                    );
                                }, this).length)
                        },
                        value: true,
                        text: iget2('dm-mobile-content-group', 'ne-ukazany-klyuchevye-frazy', 'Не указаны ключевые фразы')
                    },
                    hasActive: {
                        text: function() {
                            return iget2(
                                'dm-mobile-content-group',
                                'u-gruppy-dolzhna-byt',
                                'У группы должна быть указана хотя бы одна из следующих настроек: ключевые фразы, условия подбора аудитории, интересы либо автотаргетинг'
                            );
                        },

                        validate: function() {
                            var count = 0,
                                state,
                                relevanceMatchModel = this.getRelevanceMatchModel();

                            if (this.get('new_phrases').length > 0) return true;

                            this.getRetargetingsModels().map(function(model) {
                                if (!model.get('is_suspended') && !model.get('is_deleted')) {
                                    count++
                                }
                            }, this);

                            this.getPhrasesModels().map(function(model) {
                                state = model.get('state');

                                if (state !== 'low_ctr' && state !== 'declined' && !model.get('is_suspended') &&
                                    !model.get('is_deleted')) {

                                    count++
                                }
                            }, this);

                            this.get('target_interests') && (count += this.get('target_interests').length);

                            this.get('has_relevance_match') && count++;

                            return !!count;
                        }
                    },
                    phraseCount: {
                        text: function() {
                            var limit = this.getKeywordLimit();
                            return u.pluralForms(iget2(
                                'dm-mobile-content-group',
                                'gruppa-dolzhna-soderzhat-ne',
                                'Группа должна содержать не более {foo} {ключевой фразы|ключевых фраз|ключевых фраз}',
                                {
                                    foo: limit
                                }
                            ), limit);
                        },
                        validate: function() {
                            return this.getPhrasesLeft() >= 0;
                        }
                    }
                }
            }
        },

        mobile_app_goal: 'string',

        displayedAttributes: { type: 'array' },

        hasMobileApp: { type: 'boolean', default: false },

        // данные о размерах загруженых креативов
        usedResolutions: {
            type: 'array',
            dependsFrom: 'banners',
            calculate: function() {
                var sizes = [];

                this.get('banners').where({ ad_type: 'image_ad' }).forEach(function(banner) {
                    if (banner.get('imageSize')) {
                        sizes.push(banner.get('imageSize'));
                    }
                });

                return u._.uniq(sizes);
            }
        }

    }, {
        init: function() {
            this.on('store_content_href', 'change', $.debounce(function() {
                this.get('mobile_content_exist') ||
                    this.updateMobileContentInfo(this.get('store_content_href'));
            }, 100), this);

            this.on('mobile_content', 'change', $.debounce(function() {
                this._updateBannersByMobileContent();
            }), this);
        },

        /**
         * Обновляет информацию о мобильном контенте по текущей ссылке
         * @param {String} url ссылка на мобильное приложение
         * @returns {*}
         */
        updateMobileContentInfo: function(url) {
            var dfd = $.Deferred(),
                mobileAppsClient = BEM.blocks['i-web-api-request'].mobileApps,
                errorMsg = iget2('dm-mobile-content-group', 'error-fetch-app1', 'Не удалось получить данные из магазина приложений');

            this.set('mobile_content_request_error', '');

            if (u.stripHttp(url)) {
                this.set('mobile_content_updating', true);

                mobileAppsClient.getAppContent(u.consts('ulogin'), url)
                    .then(function(result) {
                        if (result.success) {
                            this.get('mobile_content').update(result.result);
                            this.set('mobile_content_updating', false);

                            dfd.resolve(this.get('mobile_content'));
                        } else {
                            this.get('mobile_content').clear();
                            this.set('mobile_content_updating', false);

                            dfd.resolve(this.get('mobile_content'));

                            this.set('mobile_content_request_error', errorMsg);
                            this.trigger('store_content_href', 'error', { text: errorMsg });
                        }
                    }.bind(this))
                    .catch(function(e) {
                        this.get('mobile_content').clear();
                        this.set('mobile_content_updating', false);

                        dfd.resolve(this.get('mobile_content'));

                        this.set('mobile_content_request_error', errorMsg);
                        this.trigger('store_content_href', 'error', { text: errorMsg });
                    }.bind(this));
            } else {
                this.get('mobile_content').clear();

                dfd.resolve(this.get('mobile_content'));
            }

            return dfd.promise();
        },

        isLastActive: function(phraseModel) {
            var state = phraseModel.get('state');

            if (this.get('new_phrases').length > 0) return false;

            if (phraseModel.get('is_suspended') ||
                state != 'active' && state != 'new' && state != 'context') return false;

            var count = 0,
                modelId = phraseModel.get('modelId'),
                relevanceMatchModel = this.getRelevanceMatchModel(),
                relevanceMatchOn = relevanceMatchModel.get('bid_id') != '0' || this.get('has_relevance_match');

            this.getRetargetingsModels().map(function(model) {
                if (model.get('modelId') !== modelId && !model.get('is_suspended') && !model.get('is_deleted')) {
                    count++
                }
            }, this);

            this.getInterestsModels().map(function(model) {
                if (model.get('modelId') !== modelId && !model.get('is_suspended') && !model.get('is_deleted')) {
                    count++
                }
            }, this);

            this.getPhrasesModels().map(function(model) {
                state = model.get('state');

                if (model.get('modelId') !== modelId && state !== 'low_ctr' &&
                    state !== 'declined' && !model.get('is_suspended') && !model.get('is_deleted')) {
                    count++
                }
            }, this);

            modelId !== relevanceMatchModel.get('modelId') && relevanceMatchOn &&
                !relevanceMatchModel.get('is_suspended') && !relevanceMatchModel.get('is_deleted') &&
                count++;

            return count < 1;
        },

        /**
         * Обновляет поля reflected_attrs баннеров по данным о мобильном приложении
         * @private
         */
        _updateBannersByMobileContent: function() {
            var mobileContent = this.get('mobile_content').toJSON(),
                bannerData = {
                    reflected_attrs: u['dm-mobile-content'].getAvailableAttrs(mobileContent)
                };

            this.getBanners().forEach(function(bannerModel, i) {
                var hashFlags = $.extend({}, bannerModel.get('hash_flags')),
                    extraData = {},
                    age = mobileContent.age_label || '18+';

                if (i === 0) { extraData.title = mobileContent.name; }
                if (!mobileContent.mobile_content_id) { extraData.href = '';}

                hashFlags.age = age.substring(0, age.length - 1);
                bannerData.hash_flags = hashFlags;
                bannerModel.update(u._.extend({}, bannerData, extraData));
            });
        },

        getActivePhrasesCount: function() {},
        getLowCtrPhrasesCount: function() {},
        getDeclinedPhrasesCount: function() {},

        /**
         * Возвращает данные, необходимые для отрисовки ошибок в хедере
         * @returns {Object}
         */
        toJSONForErrors: function() {
            var res = {};

            ['isCopyGroup', 'newGroupIndex', 'isNewGroup', 'isSingleGroup', 'adgroup_id', 'modelId']
                .forEach(function(name) {
                    res[name] = this.get(name);
                }, this);

            return res;
        },

        getAllPhrases: function() {
            return [].concat(this.get('new_phrases'), this.getPhrases());
        },

        getPhrasesLength: function() {
            return this.getPhrases().join(',').length;
        },

        /**
         * Возвращает массив с данными по фразам, содержащимся в данной группе
         * @returns {Array}
         */
        getPhrasesData: function() {
            var _this = this,
                phrases = this.get('phrasesIds').reduce(function(goodPhrases, id) {
                    var model = BEM.MODEL.getOrCreate({
                        name: _this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                        id: id,
                        parentModel: _this
                    });

                    // DIRECT-40060
                    // исключаем пустые фразы
                    model.get('phrase') && goodPhrases.push(model.toJSON());

                    return goodPhrases;
                }, []),
                newPhrases = this.get('new_phrases');

            if (newPhrases.length) {
                phrases = phrases.concat(newPhrases.map(function(phrase) {
                    return {
                        phrase: phrase,
                        id: 0
                    };
                }));
            }

            return phrases;
        },

        /**
         * Возвращает количество ключевых фраз, которое еще можно добавить
         * @returns {Number}
         */
        getPhrasesLeft: function() {
            return this.getKeywordLimit() - this.getAllPhrases().length;
        },

        /**
         * Возвращает массив с данными по условиям ретаргетинга, содержащимся в данной группе
         * @returns {Array}
         */
        getRetargetingsData: function() {
            var modelData;

            return this.get('retargetingsIds').map(function(ret) {

                if (this.get('isBidable')) {
                    modelData = BEM.MODEL.getOrCreate({
                        name: 'm-retargeting-bidable',
                        id: ret.ret_cond_id,
                        parentModel: this
                    }).toJSON();

                    modelData.ret_id = ret.ret_id;

                    return modelData;

                } else {
                    modelData = BEM.MODEL.getOrCreate({
                        name: 'm-retargeting-condition',
                        id: ret.ret_cond_id
                    }).toJSON();
                    modelData.ret_id = ret.ret_id;

                    return modelData;
                }
            }, this);
        },

        /**
         * Возвращает массив с данными по интересам, содержащимся в данной группе
         * @returns {Array}
         */
        getInterestsData: function() {
            var modelData;

            return this.get('interestsIds').map(function(ret) {
                modelData = BEM.MODEL.getOrCreate({
                    name: 'm-interest-bidable',
                    id: ret.ret_id + '-' + ret.target_category_id,
                    parentModel: this
                }).toJSON();

                modelData.ret_id = ret.ret_id;
                modelData.target_category_id = ret.target_category_id;

                return modelData;
            }, this);
        },

        addBanner: function(defaults) {
            // отфильтровываем только новые баннеры, чтобы сделать для них свою нумерацию
            var newBanners = this.getBannersWhere({ isNewBanner: true }),
                // для нового баннера берём номер предыдущего(последнего) нового баннера в списке,
                // чтобы не было проблем после удаления одного из ранее созданных
                newBannerIndex = newBanners.length ?
                    +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                    1,
                newBannerId = 'new' + newBannerIndex,
                mobileContent = this.get('mobile_content').toJSON(),
                ageLabel = mobileContent.age_label,
                modelData = u._.extend(
                    {},
                    defaults,
                    {
                        reflected_attrs: this.get('hasMobileApp') ?
                            this.get('displayedAttributes') :
                            u['dm-mobile-content'].getAvailableAttrs(mobileContent),
                        hash_flags: ageLabel && {
                            age: ageLabel.substring(0, ageLabel.length - 1)
                        }
                    },
                    this._getPrevNewBannerData(),
                    {
                        bid: 0,
                        newBannerIndex: newBannerIndex,
                        modelId: newBannerId,
                        hasCopyFromPrev: true
                    }
                );

            return this.addBannerToList(modelData);
        },

        _getPrevNewBannerData: function() {
            var newBanners = this.getBannersWhere({ isNewBanner: true }),
                prevBanner = newBanners.length ? newBanners[newBanners.length - 1] : null,
                prevBannerData = prevBanner ? prevBanner.provideData() : {};

            // картинку в ГО не копируем
            delete prevBannerData.image_ad;
            // тип не копируем, потому-что он определяется в другом месте
            delete prevBannerData.ad_type;
            // удаляем все креативы, иначе превью нового баннера их покажет
            delete prevBannerData.creative;
            // удаляем трекинговую ссылку, иначе она прорастет во все банера, вне зависимости от выбора пользователя
            delete prevBannerData.href;

            return prevBannerData;
        },

        /**
         * Возвращает модель региона для данной группы
         * @returns {BEM.MODEL}
         */
        getGeoModel: function() {
            return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });
        },

        /**
         * Возвращает данные в формате, пригодном для сохранения на сервере
         * @returns {Object}
         */
        provideData: function() {
            var data = this.toJSON(),
                geoModel = this.getGeoModel(),
                randPhrase = this.getRandomActivePhraseModel();

            data.banners = this.getBanners()
                .filter(function(bannerModel) { return bannerModel.get('archive') !== 'Yes'; })
                .map(function(bannerModel) { return bannerModel.provideData(); });

            data.tags = {};

            this.get('tags').forEach(function(model) {data.tags[model.get('id')] = 1;});

            data.geo = geoModel.get('geo');

            // При добавлении нового объявления на странице редактирования, результат метода provideData передается в
            // bemhtml блока b-edit-banner, а после в блок превью баннера.
            // Добавил сюда phrases для подстановки фразы на место шаблона в новом превью и подписки на изменение.
            randPhrase && (data.phrases = [{
                modelName: randPhrase.name,
                modelId: randPhrase.get('modelId'),
                key_words: randPhrase.get('key_words'),
                param1: randPhrase.get('param1'),
                param2: randPhrase.get('param2')
            }]);

            // для получения модели кампании на 2-ом шаге редактирования
            data.cid = this.get('cid');

            return data;
        },

        /**
         * Преобразовывает серверные данные по баннеру в модельные
         * @param {Object} data
         * @returns {Object}
         */
        bannerDataToModelData: function(data) {
            return u['dm-mobile-content-group'].transformBannerData({
                banner: data,
                group: this.provideData()
            });
        },

        /**
         * Преобразовывает серверные данные по группе в модельные (включая баннеры)
         * @param {Object} data
         * @returns {Object}
         */
        dataToModelData: function(data) {
            return u['dm-mobile-content-group'].transformData({
                group: data
            });
        },

        /**
         * Возвращает массив фраз, содержащихся в данной группе
         * @returns {Array}
         */
        getPhrases: function() {
            return this.get('phrasesIds').map(function(id) {
                return BEM.MODEL.getOrCreate({
                    name: this.get('isBidable') ?
                        'm-phrase-bidable' :
                        'm-phrase-text',
                    id: id,
                    parentModel: this
                }).get('phrase');
            }, this);
        },

        /**
         * Возвращает массив с моделями фраз, содержащихся в данной группе
         * @returns {Array}
         */
        getPhrasesModels: function() {
            return this.get('phrasesIds').map(function(id) {
                return BEM.MODEL.getOrCreate({
                    name: this.get('isBidable') ?
                        'm-phrase-bidable' :
                        'm-phrase-text',
                    id: id,
                    parentModel: this
                });
            }, this);
        },

        /**
         * Возвращает массив с моделями условий ретаргетинга, содержащихся в данной группе
         * @returns {Array}
         */
        getRetargetingsModels: function() {
            return this.get('retargetingsIds').map(function(id) {
                return BEM.MODEL.getOrCreate({
                    name: 'm-retargeting-bidable',
                    id: id.ret_cond_id,
                    parentModel: this
                });
            }, this);
        },

        /**
         * Возвращает модель бесфразного таргетинга (1 на группу)
         * @returns {*}
         */
        getRelevanceMatchModel: function() {
            return BEM.MODEL.getOrCreate({ name: 'm-relevance-match', id: this.get('modelId'), parentModel: this });
        },

        /**
         * Возвращает массив с моделями интересов, содержащихся в данной группе
         * @returns {Array}
         */
        getInterestsModels: function() {
            return this.get('interestsIds').map(function(id) {
                return BEM.MODEL.getOrCreate({
                    name: 'm-interest-bidable',
                    id: id.ret_id + '-' + id.target_category_id,
                    parentModel: this
                });
            }, this);
        },

        /**
         * Возвращает массив (серверное требование) с данными по бесфразному таргетингу
         * @returns {Array}
         */
        getRelevanceMatchData: function() {
            var model = this.getRelevanceMatchModel(),
                json = model.toJSON(),
                data = u._.pick(json, ['bid_id', 'is_suspended', 'search_stop', 'net_stop']);

            data.price = model.get('price', 'formatted');
            data.price_context = model.get('price_context', 'formatted');

            return [data];
        },

        /**
         * Возвращает true если хотя бы одна фраза из содержащихся в группе была изменена
         * @returns {Boolean}
         */
        isPhrasesChanged: function() {
            return this.get('phrasesIds').some(function(id) {
                return BEM.MODEL.getOrCreate({
                    name: this.get('isBidable') ?
                        'm-phrase-bidable' :
                        'm-phrase-text',
                    id: id,
                    parentModel: this
                }).isChanged('phrase');
            }, this);
        },

        getMultipliersData: function() {
            return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
        },

        getKeywordLimit: function() {
            return this.getCampaignModel().get('maxKeywordLimit');
        }
    });
})();
