//@heliarian перенесено из dm-mobile-content-group.bemtree.xjst
u.register({

    'dm-mobile-content-group': {

        /**
         * Преобразовывает серверные данные группы в модельные
         * @param {Object} options
         * @param {Object} options.group
         * @param {Array} options.campaignTags
         * @param {Object} options.campaign
         * @param {Boolean} options.loadVCardFromClient
         * @returns {*}
         */
        transformData: function(options) {
            var group = options.group,
                campaign = options.campaign || {},
                campaignTags = options.campaignTags,
                copyGroupNameRegExp = RegExp('.*\\(' + iget2('dm-mobile-content-group', 'kopiya', 'копия') + '\\)$', 'gi'),
                selectedMobileApp = group.selected_mobile_app || campaign.selected_mobile_app,
                data = [
                    'archive',
                    'modelId',
                    'errors',
                    'isBidable',
                    'mobile_content',
                    'store_content_href',
                    'adgroup_type',
                    'device_type_targeting',
                    'network_targeting',
                    'is_group_copy_action',
                    'has_general_limit_price',
                    'adgroup_id',
                    'banners_quantity',
                    'group_banners_types',
                    'is_completed_group',
                    'statusOpenStat',
                    'autobudget',
                    'day_budget_show_mode',
                    'autobudget_date',
                    'camp_type',
                    'group_name',
                    'banners',
                    'phrases',
                    'minus_words',
                    'relevance_match',
                    'forecastDate',
                    'cstatusModerate',
                    'statusEmpty',
                    'cstatusContextStop',
                    'sum_to_pay',
                    'auto_optimization',
                    'banners_arch_quantity',
                    'PriorityID',
                    'retargetings',
                    'target_interests',
                    'has_relevance_match',
                    'statusModerate',
                    'statusPostModerate',
                    'statusBsSynced',
                    'statusShowsForecast',
                    'geo',
                    'geo_names',
                    'tag_ids',
                    'cstatusShow',
                    'total_banners',
                    'is_oversized',
                    'cid',
                    'isCopyGroup',
                    'newGroupIndex',
                    'isNewGroup',
                    'bannersIds',
                    'min_os_version',
                    'new_phrases',
                    'statusMetricaStop'
                ].reduce(function(data, name) {
                    data[name] = group[name];

                    return data;
                }, {});

            if (!data.group_name) data.group_name = iget2('dm-mobile-content-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

            if (data.is_group_copy_action && !data.group_name.match(copyGroupNameRegExp)) {
                data.group_name = data.group_name + ' (' + iget2('dm-mobile-content-group', 'kopiya', 'копия') + ')';
            }

            if (selectedMobileApp) {
                data.hasMobileApp = true;
                data.mobile_content_exist = true;
                data.displayedAttributes = selectedMobileApp.displayedAttributes.map(function(attr) {
                    return attr.toLowerCase();
                });
            } else {
                data.hasMobileApp = false;
            }

            // если это создание группы и у нас есть приложение выбранное на странице кампании
            if (data.isNewGroup && selectedMobileApp) {
                data.mobile_content = selectedMobileApp.mobileContent;
                data.min_os_version =
                    u._.contains(u.consts('MOBILE_OS_VERSIONS')[data.mobile_content.os_type], data.mobile_content.min_os_version) ?
                        data.mobile_content.min_os_version :
                        u.consts('MOBILE_OS_VERSIONS')[data.mobile_content.os_type][0];
                data.store_content_href = selectedMobileApp.storeHref;
            } else {
                data.mobile_content = data.mobile_content || {};
            }

            data.mobile_content.modelId = group.modelId;

            // Заполняем app_goal в зависимости от стратегии
            // мета-цель закрашивается и это место не убираем, т.к. потом надо будет "раскрасить" обратно
            var strategyToCheck = u._.get(campaign, 'strategy.search', {});

            if (strategyToCheck.name === 'stop') {
                strategyToCheck = campaign.net || {};
            }

            if (strategyToCheck.name === 'autobudget_avg_cpi' ||
                (strategyToCheck.name === 'autobudget' && strategyToCheck.goal_id === '4')) {
                data.mobile_app_goal = 'installs';
            }

            if (!(data.device_type_targeting && data.device_type_targeting.length)) {
                data.device_type_targeting = campaign.device_type_targeting && campaign.device_type_targeting.length ?
                    campaign.device_type_targeting :
                    ['phone', 'tablet'];
            }

            if (!(data.network_targeting && data.network_targeting.length)) {
                data.network_targeting = campaign.network_targeting && campaign.network_targeting.length ?
                    campaign.network_targeting :
                    ['wifi', 'cell'];
            }

            //по пришедшим id тегов строим полный массив данных
            if (group.tags && !u._.isArray(group.tags)) {
                data.tags = Object.keys(group.tags).map(function(id) {
                    var cTag = (campaignTags || []).filter(function(tag) {
                        return tag.id === id;
                    }).pop();

                    return {
                        id: id,
                        value: cTag && cTag.value
                    };
                }, this);
            }

            data.phrasesIds = group.phrases ?
                group.phrases.map(function(phrase) {
                    return phrase.modelId;
                }, this) :
                [];

            data.retargetingsIds = group.retargetings ?
                group.retargetings
                    .filter(function(retargeting) {
                        return retargeting.conditions_type === 'metrika_goals';
                    })
                    .map(function(retargeting) {
                        return {
                            ret_id: retargeting.ret_id,
                            ret_cond_id: retargeting.ret_cond_id
                        }
                    }, this) :
                [];

            data.interestsIds = group.target_interests ?
                group.target_interests.map(function(interest) {
                    return {
                        ret_id: interest.ret_id,
                        target_category_id: interest.target_category_id
                    }
                }, this) :
                [];

            if (group.tags) {
                data.tags = u._.isArray(group.tags) ?
                    group.tags :
                    //по пришедшим id тегов строим полный массив данных
                    Object.keys(group.tags).map(function(id) {
                        var cTag = (campaignTags || []).filter(function(tag) {
                            return tag.id === id;
                        }).pop();

                        return {
                            id: id,
                            value: cTag && cTag.value
                        };
                    }, this);
            }

            data.banners = u._.isArray(group.banners) ?
                group.banners.map(function(banner) {
                    return u['dm-mobile-content-group'].transformBannerData({
                        banner: banner,
                        group: group,
                        campaign: campaign
                    });
                }) :
                [
                    u['dm-mobile-content-group'].transformBannerData({
                        banner: group,
                        group: group,
                        campaign: campaign
                    })
                ];

            data.has_relevance_match = group.has_relevance_match ||
                group.relevance_match && group.relevance_match.length > 0 ||
                    !!selectedMobileApp && data.isNewGroup;

            return data;
        },

        /**
         * Преобразовывает серверные данные баннера в модельные
         * @param {Object} options
         * @param {Object} options.banner
         * @param {Object} options.group
         * @returns {*}
         */
        transformBannerData: function(options) {
            // DIRECT-39276, DIRECT-49050: statusModerate - поле группы, но оно нужно для блока b-banner-status,
            // подобная логике есть в предобработке данных для баннеров/групп i-banners-group-data.bemtree.xjst
            options.banner.groupStatusModerate = options.group.statusModerate;

            // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
            options.banner.url_protocol || (options.banner.url_protocol = u.getUrlProtocol(options.banner.href));

            return u['dm-mobile-content-banner'].transformData({
                banner: u.bannerData({
                    banner: options.banner
                }),
                group: options.group,
                campaign: options.campaign || {}
            });
        }
    }
});
