BEM.MODEL.decl('dm-mobile-content', {

    modelId: 'id',

    // Id мобильного приложения
    mobile_content_id: 'number',

    // Название приложения
    name: 'string',

    // основная цена за приложение, == 0 - приложение бесплатное
    prices: 'object',

    // флаг, поддерживает ли БК данную валюту
    isCurrencySupported: {
        type: 'boolean',
        dependsFrom: 'prices',
        calculate: function() {
            var prices = this.get('prices');

            return !!u.currencies.get(prices && prices.download ? prices.download.price_currency : '' );
        }
    },

    // Рейтинг приложения в магазине
    rating: 'number',

    // Рейтинг приложения в магазине
    rating_votes: 'number',

    // URL до статического файла с иконкой приложения
    icon_url: 'string',

    // Тип операционной системы
    os_type: {
        type: 'enum',
        enum: [
            'iOS',
            'Android'
        ]
    },

    // минимальная версия ОС поддерживаемая приложением
    min_os_version: 'string',

    // действия которые можно делать с приложением внутри магазина
    available_actions: 'array',

    // доступно ли в данный момент приложение
    is_available: 'boolean',

    // Категория приложения внутри магазина
    category: {
        type: 'enum',
        enum: [
            'soft',
            'movie',
            'book',
            'game',
            'music',
            'newsstand'
        ]
    },

    // Возрастная метка на приложение из магазина приложений
    age_label: {
        type: 'enum',
        enum: [
            '18+',
            '16+',
            '12+',
            '6+',
            '0+'
        ]
    },

    // Показывать ли иконку приложения
    is_show_icon: 'boolean',

    // Взята страна по умолчанию
    is_default_country: 'boolean',

    // Домен разработчика
    publisher_domain: 'string'
});
