u.register({
    'dm-mobile-content': {

        /**
         * Возвращает строковое представление цены приложения или пустую строку
         * @param {Object} mobileContent Данные мобильного приложения
         * @returns {string}
         */
        getPrice: function(mobileContent) {
            var prices = mobileContent.prices,
                price = '';

            if (prices) {
                var action = Object.keys(prices)[0],
                    actionPrice = action && prices[action];

                if (actionPrice && +actionPrice.price) {
                    price = u.currencies.formatSum(actionPrice.price_currency, actionPrice.price);
                }
            }

            return price;
        },

        /**
         * Возвращает массив доступных атрибутов для мобильного приложения
         * возможные варианты ['rating', 'price', 'icon', 'rating_votes']
         * @param {Object} mobileContent Данные мобильного приложения
         * @returns {Array}
         */
        getAvailableAttrs: function(mobileContent) {
            return [
                'rating',
                'price',
                'icon',
                'rating_votes'
            ].reduce(function(attrs, field) {
                if (field === 'price') {
                    if (u['dm-mobile-content'].getPrice(mobileContent)) {
                        attrs.push(field);
                    }
                } else if (field === 'rating_votes') {
                        // количество отзывов доступно, только если доступен рейтинг
                    if (mobileContent.rating && mobileContent.rating_votes) {
                        attrs.push(field);
                    }
                } else if (field === 'icon' && mobileContent['icon_url']) {
                    attrs.push(field);
                } else if (mobileContent && mobileContent[field]) {
                    attrs.push(field);
                }

                return attrs;
            }.bind(this), []);
        },

        /**
         * Проверяет являются ли данные приложения неполными
         * @param {Object} mobileContent Данные мобильного приложения
         * @returns {Boolean}
         */
        isCorruptedData: function(mobileContent) {
            return !!mobileContent.name && ![
                'rating',
                'price',
                'icon_url',
                'rating_votes'
            ].every(function(field) {
                if (field === 'price') {
                    var prices = mobileContent.prices;

                    if (prices) {
                        var action = Object.keys(prices)[0],
                            actionPrice = action && prices[action];

                            // достаточно наличия поля
                        if (actionPrice && 'price' in actionPrice) {
                            return true;
                        }
                    }

                    return false;
                } else if (mobileContent && !mobileContent[field]) {
                    return false;
                }

                return true;
            });
        }
    }
});
