BEM.MODEL.decl('dm-retargeting', {

    ret_cond_id: {
        type: 'number'
    },

    ret_id: {
        type: 'number'
    },

    condition_name: {
        type: 'string',
        validation: {
            rules: {
                nonEmpty: {
                    validate: function(val) {
                        return this.isNotEmpty(val);
                    },
                    text: iget2(
                        'dm-retargeting',
                        'required-error',
                        'Это обязательное поле'
                    )
                },
                maxLength: {
                    needToValidate: function(val) {
                        return this.isNotEmpty(val);
                    },
                    validate: function(val) {
                        return (val.length <= u.consts('cryptaNameMaxLength'));
                    },
                    text: function() {
                        return iget2(
                            'dm-retargeting',
                            'maxlength-error',
                            'Длина не может превышать {number} символов',
                            {
                                number: u.consts('cryptaNameMaxLength')
                            }
                        );
                    }
                }
            }
        }
    },

    description: 'string',

    forbidToUse: {
        type: 'array',
        default: []
    },

    isNegative: {
        type: 'boolean',
        default: false,
        internal: true,
        dependsFrom: ['groups'],
        calculate: function() {
            var groups = this.get('groups');

            return !!groups.length && groups.every(function(group) {
                return group.type === 'not';
            });
        }
    },

    type: {
        type: 'string',
        default: 'interests'
    },

    // список сегментов
    segments: {
        type: 'object',
        internal: true
    },

    'social-demo': {
        type: 'array',
        default: [],
        internal: true
    },

    family: {
        type: 'array',
        default: [],
        internal: true
    },

    behaviors: {
        type: 'array',
        default: [],
        internal: true
    },

    metrika: {
        type: 'array',
        default: [],
        internal: true
    },

    'audio-genres': {
        type: 'array',
        default: [],
        internal: true
    },

    groups: {
        type: 'array',
        dependsFrom: ['social-demo', 'family', 'metrika', 'interests', 'behaviors', 'audio-genres'],
        calculate: function() {
            return this.calculateGroups();
        }
    },

    interests: {
        type: 'array',
        default: [],
        internal: true
    }

}, {

    getByTypes: function(types) {
        var _this = this;

        return types
            .reduce(function(result, type) {
                return result.concat(_this.get(type) || []);
            }, [])
            .filter(function(group) {
                group.goals = group.goals.filter(function(goal) { return goal.id; });

                return group.goals.length;
            });
    },

    /**
     * Высчитывает формулу выбранных сегментов
     * @return {Array<group>}
     */
    calculateGroups: function() {
        var socdemo = this.get('social-demo') || [],
            family = this.get('family') || [],
            interests = this.get('interests') || [],
            metrika = this.get('metrika') || [],
            behaviors = this.get('behaviors') || [],
            genres = this.get('audio-genres') || [];

        return socdemo
            .concat(family, metrika, interests, behaviors, genres)
            .filter(function(group) {
                group.goals = group.goals.filter(function(goal) { return goal.id; });

                return group.goals.length;
            });
    },

    /**
     * Проверяет на пустое значение
     * @param {String} val
     * @return {Boolean}
     */
    isNotEmpty: function(val) {
        return !val.match(/^\s*$/);
    }
});
