/**
 * @typedef {Object} Segment
 * @property {Number} modelId - id модели
 * @property {Number} id - id сегмента
 * @property {Number} parent_id - id родительского сегмента
 * @property {String} name - имя
 * @property {String} description - описание
 * @property {CryptaType} type - тип
 * @property {'gender'|'age'|'finance'|undefined} subtype - тип
 * @property {Boolean} checked - выбран
 * @property {Boolean} disabled - выключен
 */

BEM.MODEL.decl('dm-segment', {

    modelId: {
        type: 'id'
    },
    id: 'number',
    parent_id: 'number',
    name: 'string',
    description: 'string',
    type: 'string',
    interest_type: 'string',
    checked: {
        type: 'boolean',
        default: false
    },
    disabled: {
        type: 'boolean',
        default: false
    },
    disabled_message: {
        type: 'string',
        default: ''
    },
    can_select_all: 'boolean'
}, {

});
