BEM.DOM.decl({ block: 'dropdown-chooser-popup', modName: 'multi', modVal: 'yes' }, {

    /**
     * Возвращает необходимые модификаторы блока `b-choosed`
     * @return {object}
     * @private
     */
    _getChooserMods: function() {
        return { search: 'yes', theme: 'checkboxes', multi: 'yes' };
    },

    /**
     * Обработчик выбора в `b-chooser`
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string} data.name
     * @param {boolean} data.selected
     * @private
     */
    _onChoose: function(e, data) {
        this.trigger('choose', {
            itemId: data.name,
            isSelected: data.selected,
            value: u._.map(e.block.getAll('selected'), 'name')
        });
    }
});
