BEM.DOM.decl('dropdown-chooser-popup', {

    onSetMod: {
        js: function() {
            this.setMod('loading', 'yes');
        }
    },

    /**
     * Отрисовывает элементы списка (с выбранными элементами на основании `value`)
     * @param {{ id: String, name: String, addition: String }[]} items
     * @param {string[]} value
     */
    drawItems: function(items, value) {
        this._drawContent(BEMHTML.apply(this._getPopupBemjson(items, value)));
    },

    /**
     * Отрисовывает заглушку с контентом (когда элементов списка, например, нет)
     * @param {bemjson} bypassContent
     */
    drawBypass: function(bypassContent) {
        this._drawContent(BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'bypass',
            content: bypassContent
        }));
    },

    _drawContent: function(content) {
        this.delMod('loading');

        this.blockInside('popup2').setContent(content);
    },

    /**
     * Ставит фокус в поле поиска
     */
    focusSearch: function() {
        this.blockInside('b-chooser') && this.blockInside('b-chooser').getInput().setMod('focused', 'yes');
    },

    /**
     * Генерирует bemjson попапа
     * @param {{ id: string, name: string, addition: string, isDisabled: boolean }[]} items
     * @param {string[]} value
     * @return {object}
     * @private
     */
    _getPopupBemjson: function(items, value) {
        return {
            block: 'b-chooser',
            mods: this._getChooserMods(),
            content: [
                { elem: 'search' },
                {
                    block: 'b-overflow-luxury-scroll',
                    mix: { block: this.__self.getName(), elem: 'overflow' },
                    js: { bleachHeight: 15 },
                    content: {
                        block: 'b-chooser',
                        elem: 'wrap',
                        mods: this._getChooserMods(),
                        mix: { block: this.__self.getName(), elem: 'wrap-items' },
                        content: items.map(function(item) {
                            return {
                                elem: 'item',
                                elemMods: {
                                    selected: u._.includes(value, item.id) ? 'yes' : '',
                                    disabled: item.isDisabled ? 'yes' : ''
                                },
                                js: { search: u._.pick(item, ['name', 'addition']) },
                                name: item.id,
                                content: [
                                    {
                                        block: 'dropdown-chooser-popup',
                                        elem: 'name',
                                        mix: { block: 'b-chooser', elem: 'name' },
                                        content: item.name
                                    },
                                    item.addition ?
                                        {
                                            block: 'dropdown-chooser-popup',
                                            elem: 'addition',
                                            mix: { block: 'b-chooser', elem: 'addition' },
                                            content: item.addition
                                        } :
                                        ''
                                ]
                            };
                        })
                    }
                },
                {
                    elem: 'not-found',
                    mix: {
                        block: 'dropdown-chooser-popup',
                        elem: 'not-found'
                    },
                    content: this.params.notFoundText
                }
            ]
        };
    },

    /**
     * Возвращает необходимые модификаторы блока `b-choosed`
     * @return {object}
     * @private
     */
    _getChooserMods: function() {
        return { search: 'yes', theme: 'radioboxes' };
    },

    /**
     * Открывает попап
     * @param {jQuery} domElem
     * @return {BEM.DOM}
     */
    open: function(domElem) {
        this.domElem.css('width', domElem.width());

        this.blockInside('popup2')
            .setAnchor(domElem)
            .setMod('visible', 'yes');

        return this;
    },

    /**
     * Закрывает попап
     */
    close: function() {
        this.blockInside('popup2').delMod('visible');
    },

    /**
     * Обработчик событий открытия и закрытия попапа
     * @param {jQuery.Event} e
     * @private
     */
    _onPopupOpenClose: function(e) {
        if (e.type === 'beforeOpen') {
            this.bindToDoc('pointerclick', this._onDocClick);

            this.trigger('open')
        } else {
            this.unbindFromDoc('pointerclick', this._onDocClick);

            this.trigger('close');

            setTimeout(function() {
                this.trigger('afterClose');
            }.bind(this), 1000);
        }
    },

    /**
     * Обработчик выбора в `b-chooser`
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string} data.name
     * @param {boolean} data.selected
     * @private
     */
    _onChoose: function(e, data) {
        this.trigger('choose', {
            itemId: data.name,
            isSelected: data.selected,
            value: [e.block.val()]
        });
    },

    /**
     * Обработчик поиска в блоке `b-chooser`
     * @private
     */
    _onChooserSearch: function() {
        // Перерсовываем попап после того как был произведен поиск, потому что высота контента могла измениться
        this.afterCurrentEvent(function() {
            this.blockInside('popup2') && this.blockInside('popup2').redraw();
        });
    },

    /**
     * Обработчик клика по документы
     * @param {jQuery.Event} e
     * @private
     */
    _onDocClick: function(e) {
        if (this.domElem.find(e.target).length || this.blockInside('popup2').domElem.find(e.target).length) {
            return;
        }

        this.blockInside('popup2').delMod('visible');
    }

}, {

    live: function() {
        this
            .liveInitOnBlockEvent('beforeOpen beforeClose', 'popup2', function(e, data) {
                this._onPopupOpenClose(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'b-chooser', function(e, data) {
                this._onChoose(e, data);
            })
            .liveInitOnBlockInsideEvent('search', 'b-chooser', function(e, data) {
                this._onChooserSearch(e, data);
            });

        return false;
    }

});
