block('filter-condition-edit-control').mod('type', 'composite')(
    js()(function() {
        var condition = this.ctx.condition;
        return {
            //если пришел пустой массив то добавляем один дефолтный для данного типа элемент в композит
            valuesList: condition.value && condition.value.length ?
                condition.value :
                u['i-filter-edit'].getDefaultValue(condition),
            maxCount: u['i-filter-edit'].getConditionMaxCount(condition),
            itemId: this.ctx.itemId,
            field: condition.field,
            relation: condition.relation
        }
    }),

    content()(function() {
        return {
            block: 'composite',
            layout: {
                block: 'filter-condition-edit-control',
                elem: 'composite-items-list'
            },
            itemView: {
                block: 'filter-condition-edit-control',
                elem: 'composite-item',
                hideCompositeControls: this.ctx.hideCompositeControls,
                errors: this.ctx.errors && this.ctx.errors.items || {},

                inputType: u['i-filter-edit'].isRangeValue(this.ctx.condition) ? 'range-input' : 'input'
            }
        }
    }),

    mix()(function() {
        return {
            block: 'i-controls-overseer',
            js: {
                of: {
                    block: 'filter-condition-edit-control',
                    elem: 'control'
                }
            }
        }
    })
);

block('filter-condition-edit-control').elem('composite-items-list').content()(function() {
    return [
        {
            block: 'composite',
            elem: 'items',
            mix: [
                {
                    block: 'filter-condition-edit-control',
                    elem: 'composite-items'
                }
            ]
        }
    ];
});

block('filter-condition-edit-control').elem('composite-item')(
    mix()(function() {
        return [{
            block: 'filter-condition-edit-control',
            elem: 'composite-item',
            elemMods: { id: this.ctx.itemData.id }
        }];
    }),

    content()(function() {
        var ctx = this.ctx,
            errors = ctx.errors[ctx.itemData.itemIndex] || [],
            errorPath = 'feed-filter-edit.filter.' + ctx.itemData.parentId + '.items[' + ctx.itemData.itemIndex + ']',
            errorMix = {
                block: 'b-error-control',
                mods: { error: errors.length ? 'yes' : '' },
                js: { path: errorPath }
            };

        return [
            {
                elem: 'composite-item-row',
                content: [
                    {
                        block: 'b-control-input',
                        mods: { 'input-type': ctx.inputType },
                        mix: { block: 'filter-condition-edit-control', elem: 'control' },
                        data: { itemId: ctx.itemData.id },
                        inputMix: ctx.inputType === 'input' ? errorMix : undefined,
                        minMix: ctx.inputType !== 'input' ? errorMix : undefined,
                        maxMix: ctx.inputType !== 'input' ? errorMix : undefined,
                        action: 'change blur',
                        value: ctx.itemData.value
                    },
                    !ctx.hideCompositeControls && {
                        block: 'filter-condition-edit-control',
                        elem: 'buttons',
                        content: [
                            {
                                block: 'b-control-button', data: { itemId: ctx.itemData.id },
                                mods: {
                                    remove: 'icon-only',
                                    disabled: ctx.itemData.canDelete ? '' : 'yes'
                                },
                                mix: [
                                    {
                                        block: 'filter-condition-edit-control', elem: 'btn-delete-value'
                                    },
                                    {
                                        block: 'filter-condition-edit-control', elem: 'control'
                                    }
                                ],
                                action: 'remove'
                            },
                            {
                                block: 'b-control-button', data: { itemId: ctx.itemData.id },
                                mods: {
                                    add: 'icon-only',
                                    disabled: ctx.itemData.canAdd ? '' : 'yes'
                                },
                                mix: [
                                    {
                                        block: 'filter-condition-edit-control', elem: 'btn-add-value'
                                    },
                                    {
                                        block: 'filter-condition-edit-control', elem: 'control'
                                    }
                                ],
                                action: 'add'
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'composite-item-row',
                content: {
                    block: 'b-error-message',
                    mods: { visible: errors.length ? 'yes' : '' },
                    js: { path: errorPath },
                    content: errors.map(function(error) {
                        return {
                            block: 'b-error-message',
                            elem: 'text',
                            content: u.escapeHTML(error.text)
                        }
                    })
                }
            }
        ];
    })
);
