BEM.DOM.decl({ block: 'filter-condition-edit-control', modName: 'type', modVal: 'composite' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _list: 'composite inside'
            });

            this._itemId = this.params.itemId;

            this._initEvents();
            this._data = [];

            //рисуем условия пришедшие с сервера
            this.params.valuesList && this.params.valuesList.length && this._addCompositeItems(this.params.valuesList);
        }
    },

    /**
     * Возвращает данные с контрола
     * @returns {*}
     */
    getData: function() {
        return this._data.map(function(data) {
            return data.value;
        });
    },

    /**
     * Устанавливаем данные в контрол
     * @param {Array} data
     * @returns {BEM}
     */
    setData: function(data) {
        this._list.clear();

        this._addCompositeItems(data);

        return this;
    },

    /**
     * Добавляет строку в список условий и обновляет массив this._data
     * @param {Object} data
     * @param {String} [at] индекс, после которого нужно вставить элемент
     * @private
     */
    _addCompositeItems: function(data, at) {
        data = data.map(function(value, i) {
            return {
                id: u._.uniqueId('filter-condition-edit-control_id_'),
                value: value
            };
        });
        data.forEach(function(item, i) {
            if (u._.isUndefined(at)) {
                this._data.push(item);
            } else {
                this._data.splice(at + i, 0, item);
            }
        }, this);

        this._list.add(data, !!at && {
            at: at
        });
    },

    /**
     *
     * @param {Array[String]} itemsIds
     * @returns {BEM}
     * @private
     */
    _onItemsRemoved: function(itemsIds) {
        itemsIds.forEach(function(itemId) {
            u._.remove(this._data, function(item) {
                return item.id === itemId;
            });
        }, this);

        this._updateItemsList();

        return this;
    },

    /**
     *
     * @param {Array} items
     * @returns {BEM}
     * @private
     */
    _onItemsAdded: function(items) {
        this._updateItemsList();

        return this;
    },

    /**
     * Возвращаем индекс элемента в списке по данному itemId
     * @param {String} itemId
     * @returns {Number}
     * @private
     */
    _getNewItemIndexById: function(itemId) {
        return this._getItemIndexById(itemId) + 1;
    },

    _onItemChanged: function(itemId, data) {
        var itemIndex = this._getItemIndexById(itemId);

        this._data[itemIndex] = { id: itemId, value: data };
    },

    /**
     * Возвращает индекс элемента в композите по его id
     * @param {String} itemId id элемента композита
     * @returns {Number}
     * @private
     */
    _getItemIndexById: function(itemId) {
        return u._.findIndex(this._data, function(item) {
            return item.id === itemId;
        });
    },

    /**
     * Реакция поля ввода на потерю фокуса
     * @param {String} itemId id элемента композита
     * @param {*} data значение элемента композита
     * @private
     */
    _onItemBlured: function(itemId, data) {
        var itemIndex = this._getItemIndexById(itemId);

        this._data[itemIndex] = {
            id: itemId,
            value: u['i-filter-edit__preprocess'].preprocessValue(this.params.field, this.params.relation, data)
        };

        this._updateItemsList(itemIndex);
    },

    _triggerChange: function() {
        this.trigger('change');
    },

    /**
     * Выполняет подписку на общие для страничных модификаторов события через i-subscription-manager
     * @private
     */
    _initCommonEvents: function() {
        this._subscriptionManager.wrap(this.findBlockOn('i-controls-overseer'))
            .on('change', function(e, params) {
                this._onItemChanged(params.data.itemId, params.value);
                this._triggerChange();
            }, this)
            .on('blur', function(e, params) {
                this._onItemBlured(params.data.itemId, params.value);
                this._triggerChange();
            }, this)
            .on('add', function(e, params) {
                //вставляем за тем контролом, на котором нажали (+)
                this._addCompositeItems(
                    u['i-filter-edit'].getDefaultValue({
                        field: this.params.field,
                        relation: this.params.relation
                    }),
                    this._getNewItemIndexById(params.data.itemId)
                );
            }, this)
            .on('remove', function(e, params) {
                this._list.remove(params.data.itemId);
            }, this);

        this._subscriptionManager.wrap(this._list)
            .on('add', function(e, data) {
                this._onItemsAdded(data.items);
                this._triggerChange();

                u.scrollNodeTo(this.findElem('composite-item', 'id', data.items[0].id), this.elem('composite-items'));
            }, this)
            .on('remove', function(e, data) {
                this._onItemsRemoved(data.items);
                this._triggerChange();
            }, this)
            .on('clear', function(e, data) {
                this._data = [];
            }, this)
    },

    _updateItemsList: function(itemIndex) {
        var toUpdate = {},
            length = this._data.length,
            canDelete = length > 1,
            canAdd = !this.params.maxCount || this.params.maxCount > length;

        if (itemIndex) {
            var item = this._data[itemIndex];

            toUpdate[item.id] = this._getHTMLItemData(item, canDelete, canAdd);
        } else {
            this._data.forEach(function(item, i) {
                toUpdate[item.id] = this._getHTMLItemData(item, canDelete, canAdd);
            }, this);
        }

        this._list.update(toUpdate);

        return this;
    },

    /**
     * Дополняет данные элемента композита для построения html
     * @param {Object} item
     * @param {Boolean} canDelete
     * @param {Boolean} canAdd
     * @returns {Object}
     * @private
     */
    _getHTMLItemData: function(item, canDelete, canAdd) {
        return u._.extend(item,
            {
                canDelete: canDelete,
                canAdd: canAdd,
                itemIndex: u._.findIndex(this._data, function(elem) {
                    return elem.id === item.id;
                }, this),
                parentId: this._itemId
            });
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base();
    }
});
