block('filter-condition-edit-control').mod('type', 'enum-one')(
    content()(function() {
        var value = this.ctx.condition.value[0],
            options = u['i-filter-edit'].getEnabledOptionsForEnumValue(this.ctx.condition),
            //heliarian говнокод для определения булевого типа, для которого надо брать текстовые расшифровки из конфига
            isBoolean = options.length == 2 && options[0] == 0 && options[1] == 1;

        return {
            block: 'select',
            mix: { block: 'filter-condition-edit-control', elem: 'select' },
            content: [
                {
                    block: 'button',
                    content: value
                },
                {
                    elem: 'control',
                    content: options.map(function(option) {
                        var isSelected = option == value,
                            attrs = { value: option };

                        if (isSelected) attrs.selected = 'selected';

                        return {
                            elem: 'option',
                            attrs: attrs,
                            mods: { selected: isSelected ? 'yes' : '' },
                            content: isBoolean ? u['i-filter-edit'].getBooleanValueTitle(option) : option
                        };
                    })
                }
            ]
        }

    })
);
