block('filter-condition-edit-control').mod('type', 'enum')(
    content()(function() {
        var value = this.ctx.condition.value,
            options = u['i-filter-edit'].getEnabledOptionsForEnumValue(this.ctx.condition);

        return {
            block: 'dropdown',
            mix: {
                block: 'filter-condition-edit-control',
                elem: 'dropdown'
            },
            content: [
                {
                    block: 'button',
                    mods: { arrow: 'down' },
                    mix: [
                        {
                            block: 'filter-condition-edit-control',
                            elem: 'switcher'
                        },
                        {
                            block: 'dropdown',
                            elem: 'switcher'
                        }
                    ],
                    content: {
                        block: 'filter-condition-edit-control',
                        elem: 'title',
                        data: value
                    }
                },
                {
                    elem: 'popup',
                    dropdownMods: { 'no-tail': 'yes' },
                    js: {
                        directions: ['bottom', 'top']
                    },
                    menuMods: { type: 'hovered' },
                    mix: [{
                        block: 'filter-condition-edit-control',
                        elem: 'chooser-popup'
                    }],
                    content: {
                        block: 'b-chooser',
                        mods: { multi: 'yes' },
                        mix: {
                            block: 'filter-condition-edit-control',
                            elem: 'chooser'
                        },
                        content: options.map(function(option) {
                            var isSelected = value && value.indexOf(option) !== -1;

                            return {
                                elem: 'item',
                                elemMods: {
                                    selected: isSelected ? 'yes' : ''
                                },
                                content: option,
                                //приводим значение к строке
                                name: option + ''
                            }
                        })

                    }
                }
            ]
        }

    })
);

block('filter-condition-edit-control').elem('title').content()(function() {
    return !this.ctx.data || !this.ctx.data.length ?
        iget2('filter-condition-edit-control', 'ne-vybrano', 'Не выбрано') :
        u.hellipCut(this.ctx.data.join(', '), 30);

});
