BEM.DOM.decl({ block: 'filter-condition-edit-control', modName: 'type', modVal: 'enum' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _chooser: 'b-chooser on chooser',
                _switcher: 'button on switcher',
                _dropdown: 'dropdown on dropdown'
            });

            this._initEvents();
        }

    },

    _initCommonEvents: function() {

        this._subscriptionManager.wrap(this._dropdown).on('show hide', function(e) {
            this._switcher.setMod('arrow', e.type == 'show' ? 'up' : 'down');
        }, this);

        this._subscriptionManager.wrap(this._chooser).on('change', function(e) {
            var selected = this.getData();

            this._switcher.elem('text').html(BEMHTML.apply({
                block: 'filter-condition-edit-control',
                elem: 'title',
                data: selected
            }));

            this.trigger('change');
        }, this);
    },

    getData: function() {
        return this._chooser.getSelected().map(function(obj) {
            return obj.name;
        });
    }
});
