block('filter-condition-edit-control').mod('type', 'textarea')(
    def()(function() {
        return applyNext({
            maxRowsNum: 5,
            maxSubStringLength: 40
        });
    }),

    js()(function() {
        return {
            field: this.ctx.condition.field,
            skipAdaptTextareaHeight: this.ctx.skipAdaptTextareaHeight,
            skipCounter: this.ctx.skipCounter,
            relation: this.ctx.condition.relation,
            maxRowsNum: this.maxRowsNum,
            maxSubStringLength: this.maxSubStringLength
        }
    }),

    content()(function() {
        var condition = this.ctx.condition,
            value = condition.value ? condition.value.join(', ') : '',
            errors = this.ctx.errors && this.ctx.errors.total || [];

        return {
            block: 'input',
            value: value,
            mix: !!this.ctx.itemId && {
                block: 'b-error-control',
                mods: { error: errors.length ? 'yes' : '' },
                js: { path: 'feed-filter-edit.filter.' + this.ctx.itemId + '.total' }
            },
            mods: { type: 'textarea' },
            placeholder: iget2('filter-condition-edit-control', 'perechislite-znacheniya-cherez-zapyatuyu', 'Перечислите значения через запятую'),
            content: [
                {
                    elem: 'control',
                    mix: {
                        block: 'filter-condition-edit-control',
                        elem: 'textarea-inner-control'
                    },
                    attrs: {
                        rows: this.ctx.rowsNumber || u['filter-condition-edit-control'].getTextareaRowsNum(
                            this.ctx.condition.value,
                            this.maxSubStringLength,
                            this.maxRowsNum
                        )
                    }
                }
            ]
        };
    })
);
