BEM.DOM.decl({ block: 'filter-condition-edit-control', modName: 'type', modVal: 'textarea' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _textarea: 'input inside'
            });

            this._onValueChangeDebounce = $.debounce(this._onValueChange, 200, this);

            this._initEvents();
        }
    },

    _initCommonEvents: function() {
        this._subscriptionManager.wrap(this._textarea)
            .on('change', function() {
                this.trigger('change');
                this._onValueChangeDebounce();
            }, this)
            .on('blur', function() {
                this._textarea.val(
                    u['i-filter-edit__preprocess'].preprocessValuesArray(
                        this.params.field,
                        this.params.relation,
                        this.getData()
                    ).join(', '));
            }, this);

        //i-subscription-manager не умеет работать с DOM-событиями
        !this.params.skipCounter && this._textarea
            .bindTo('control', 'mouseenter', function() {
                this._showHint();
            }.bind(this))
            .bindTo('control', 'mouseleave', function() {
                this._hideHint();
            }.bind(this));

    },

    _onValueChange: function() {
        !this.params.skipAdaptTextareaHeight && this._adaptTextareaHeight(this.getData());
        !this.params.skipCounter && this._updateHintPopup();
    },

    /**
     * Адаптирует textarea под длину вбитого значения
     * @param {String} value - значение
     * @private
     */
    _adaptTextareaHeight: function(value) {
        this._textarea.setRowsCount(u['filter-condition-edit-control'].getTextareaRowsNum(
            value,
            this.params.maxSubStringLength,
            this.params.maxRowsNum
        ));
    },

    _getTooltip: function() {
        return this._tooltip || (this._tooltip = this.__self.getTooltipInstance());
    },

    /**
     * Показывает попап с подсказкой
     * @private
     */
    _showHint: function() {
        var tooltip = this._getTooltip();

        this._updateHintPopup();
        tooltip.setOwner(this._textarea);
        tooltip.setMod('shown', 'yes');
    },

    _updateHintPopup: function() {
        var tooltip = this._getTooltip(),
            length = this.getData().length,
            text = length === 0 ?
                iget2('filter-condition-edit-control', 'znachenie-ne-ukazano', 'Значение не указано') :
                u.pluralizeWord([
                    iget2('filter-condition-edit-control', 'ukazano-s-znachenie', 'Указано {foo} значение', {
                        foo: length
                    }),
                    iget2('filter-condition-edit-control', 'ukazano-s-znacheniya', 'Указано {foo} значения', {
                        foo: length
                    }),
                    iget2('filter-condition-edit-control', 'ukazano-s-znacheniy', 'Указано {foo} значений', {
                        foo: length
                    })
                ], length);

        tooltip.setContent(text);
    },

    /**
     * Прячет хинт
     * @private
     */
    _hideHint: function() {
        this._getTooltip().delMod('shown');
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base();
    },

    getData: function() {
        return this._textarea.val().split(/\s*,\s*/g).filter(function(val) {
            return !u._.isEmpty(val);
        });
    }
}, {
    getTooltipInstance: function() {
        var pageElem,
            tooltip;

        if (!this._tooltip || this._tooltip._isDestructing) {
            pageElem = BEM.blocks['b-page'].getInstance().domElem;

            tooltip = {
                block: 'tooltip',
                mods: { size: 's', theme: 'normal' },
                js: { to: ['left'] }
            };

            this._tooltip = $(BEMHTML.apply(tooltip)).appendTo(pageElem).bem('tooltip');
        }

        return this._tooltip;
    }
});
