BEM.DOM.decl({ block: 'filter-condition-edit-control' }, {
    onSetMod: {
        js: function() {
            this._initEvents();
        }
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._initCommonEvents();
    },

    _initCommonEvents: function() {
        throw new Error('must be implemented in subclasses');
    },

    getData: function() {
        throw new Error('must be implemented in subclasses');
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base();
    }
});
