describe('filter-condition-edit-control', function() {
    var block,
        condition,
        sandbox,
        setModSpy,
        delModSpy,
        setOwnerSpy,
        setContentSpy;

    function createBlock(blockType, condition) {
        return u.createBlock({
            block: 'filter-condition-edit-control',
            mods: { type: blockType },
            condition: condition,
            itemId: u._.uniqueId('filter-condition-edit-control')
        }, { inject: true });
    }

    beforeEach(function() {
        sandbox = sinon.sandbox.create({
            useFakeTimers: true
        });
    });

    afterEach(function() {
        sandbox.restore();
    });

    describe('Блок filter-condition-edit-control_type_exists', function() {
        beforeEach(function() {
            condition = { field: 'delivery', relation: 'exists' };
            block = createBlock('exists', condition);
        });

        afterEach(function() {
            block.destruct();
        });

    });

    describe('Блок filter-condition-edit-control_type_enum-one', function() {
        beforeEach(function() {
            sandbox.stub(u['i-filter-edit'], 'getEnabledOptionsForEnumValue').callsFake(function() {
                return ['1', '3', '5']
            });
            sandbox.stub(u['i-filter-edit'], 'getBooleanValueTitle').callsFake(function(value) {
                return value;
            });
        });

        afterEach(function() {
            block.destruct();
        });

        describe('Отрисовываем с заданным значением', function() {
            beforeEach(function() {
                condition = { field: 'delivery', relation: 'equals', value: ['3'] };
                block = createBlock('enum-one', condition);
            });

            it('Метод getData блока filter-condition-edit-control_type_enum-one созданного с значением 3,  должен возвращать 3', function() {
                expect(block.getData()).to.be.eql(['3']);
            });
        });

        describe('Отрисовываем с заданным значением, которого нет в списке допустимых', function() {
            beforeEach(function() {
                condition = { field: 'delivery', relation: 'equals', value: ['2'] };
                block = createBlock('enum-one', condition);
            });

            it('Метод getData блока filter-condition-edit-control_type_enum-one созданного с значением 2,  должен возвращать 1', function() {
                expect(block.getData()).to.be.eql(['1']);
            });
        });

        describe('Изменение селекта внутри контрола', function() {
            beforeEach(function() {
                condition = { field: 'delivery', relation: 'equals', value: ['2'] };
                block = createBlock('enum-one', condition);
            });

        });

    });

    describe('Блок filter-condition-edit-control_type_enum', function() {
        beforeEach(function() {
            sandbox.stub(u['i-filter-edit'], 'getEnabledOptionsForEnumValue').callsFake(function() {
                return ['1', '3', '5']
            });
            sandbox.stub(u['i-filter-edit'], 'getDefaultValue').callsFake(function() {
                return ['1']
            });
        });

        afterEach(function() {
            block.destruct();
        });

        describe('Отрисовка блока без заданного значения', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==' };
                block = createBlock('enum', condition);
            });

            it('Блок должен возвращать []', function() {
                expect(block.getData()).to.be.eql([]);
            });
        });

        describe('Отрисовка блока с выбранными значениями', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==', value: ['1', '5'] };
                block = createBlock('enum', condition);
            });

            it('Блок должен возвращать [\'1\', \'5\']', function() {
                expect(block.getData()).to.be.eql(['1', '5']);
            });
        });

        describe('Реакция на действия пользователя', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==' };
                block = createBlock('enum', condition);
            });

            it('Метод getData должен возвращать выбранные значения', function() {
                block.findBlockInside('b-chooser').check('1');
                block.findBlockInside('b-chooser').check('5');
                expect(block.getData()).to.be.eql(['1', '5']);
            });
        });

    });

    describe('Блок filter-condition-edit-control_type_textarea', function() {
        beforeEach(function() {
            sandbox.stub(u['i-filter-edit'], 'getDefaultValue').callsFake(function() {
                return []
            });
        });

        afterEach(function() {
            block.destruct();
        });

        describe('Отрисовка блока без заданного значения', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==', value: [] };
                block = createBlock('textarea', condition);
            });

            it('Блок должен возвращать []', function() {
                expect(block.getData()).to.be.eql([]);
            });
        });

        describe('Отрисовка блока с выбранными значениями', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==', value: ['1', '5'] };
                block = createBlock('textarea', condition);
            });

            it('Блок должен возвращать [\'1\', \'5\']', function() {
                expect(block.getData()).to.be.eql(['1', '5']);
            });
        });

        describe('Ввод значения в поле', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==' };
                block = createBlock('textarea', condition);
            });

            it('Метод getData должен возвращать выбранные значения', function() {
                block.findBlockInside('input').val('1,5');
                expect(block.getData()).to.be.eql(['1', '5']);
            });


        });

        describe('Наведение на поле', function() {
            beforeEach(function() {
                condition = { field: 'id', relation: '==', value: [1, 3] };
                block = createBlock('textarea', condition);

                setModSpy = sandbox.spy();
                delModSpy = sandbox.spy();
                setOwnerSpy = sandbox.spy();
                setContentSpy = sandbox.spy(function() {
                    return this;
                });

                sandbox.stub(BEM.blocks['filter-condition-edit-control'], 'getTooltipInstance').callsFake(function() {
                    return {
                        setOwner: setOwnerSpy,
                        setMod: setModSpy,
                        delMod: delModSpy,
                        setContent: setContentSpy
                    }
                });
            });

            it('При наведении на поле должен выводиться метод setOwner у подсказки', function() {
                var tooltip = BEM.blocks['filter-condition-edit-control'].getTooltipInstance();

                block.findBlockInside('input').elem('control').trigger('mouseenter');

                expect(setOwnerSpy.called).to.be.true;
            });

            it('При наведении на поле должна показываться подсказка', function() {
                var tooltip = BEM.blocks['filter-condition-edit-control'].getTooltipInstance();

                block.findBlockInside('input').elem('control').trigger('mouseenter');

                expect(setModSpy.calledWith('shown', 'yes')).to.be.true;
            });

            it('При наведении на поле с пустым значением показываться подсказка', function() {
                var tooltip = BEM.blocks['filter-condition-edit-control'].getTooltipInstance(),
                    input = block.findBlockInside('input');

                input.val('');
                input.elem('control').trigger('mouseenter');

                expect(setContentSpy.calledWith('Значение не указано')).to.be.true;
            });

            it('При изменении значения в поле текст подсказки должен меняться', function() {
                var tooltip = BEM.blocks['filter-condition-edit-control'].getTooltipInstance(),
                    input = block.findBlockInside('input');

                input.elem('control').trigger('mouseenter');
                input.val('3, 4, 5');
                sandbox.clock.tick(250);
                expect(setContentSpy.calledWith('Указано 3 значения')).to.be.true;
            });

            it('При наведении на поле подсказка должна показываться с нужным значением', function() {
                var tooltip = BEM.blocks['filter-condition-edit-control'].getTooltipInstance();

                block.findBlockInside('input').elem('control').trigger('mouseenter');

                expect(setContentSpy.calledWith('Указано 2 значения')).to.be.true;
            });

            it('При событии mouseleave на поле подкасказка должна скрываться ', function() {
                var tooltip = BEM.blocks['filter-condition-edit-control'].getTooltipInstance();

                block.findBlockInside('input').elem('control').trigger('mouseleave');

                expect(delModSpy.calledWith('shown')).to.be.true;
            })
        })
    });

    [false, true].forEach(function(isRangeValue) {
        describe('Блок filter-condition-edit-control_type_composite, isRangeValue = ' + isRangeValue, function() {
            var defaultVal,
                getValue = function(val) {
                    return isRangeValue ? { min: val, max: val } : val;
                };

            beforeEach(function() {
                sandbox.stub(u['i-filter-edit'], 'getDefaultValue').callsFake(function() {
                    defaultVal = isRangeValue ? [{ min: '', max: '' }] : [''];

                    return defaultVal;
                });
                sandbox.stub(u['i-filter-edit'], 'isRangeValue').callsFake(function() {
                    return isRangeValue;
                });

                sandbox.stub(u['i-filter-edit'], 'getConditionMaxCount').callsFake(function(value) {
                    return 3;
                });
            });

            afterEach(function() {
                block.destruct();
            });

            describe('Отрисовка блока без заданного значения', function() {
                beforeEach(function() {
                    condition = { field: 'id', relation: '==' };
                    block = createBlock('composite', condition);
                });

                it('Блок должен возвращать ' + JSON.stringify(defaultVal), function() {
                    expect(block.getData()).to.be.eql(defaultVal);
                });
            });

            describe('Отрисовка блока с выбранными значениями', function() {
                beforeEach(function() {
                    condition = { field: 'id', relation: '==', value: ['1', '5'].map(getValue) };
                    block = createBlock('composite', condition);
                });

                it('Блок должен возвращать выбранные значения', function() {
                    expect(block.getData()).to.be.eql(['1', '5'].map(getValue));
                });
            });

            describe('Реакция на действия пользователя', function() {
                it('Блок должен возвращать выбранные значения', function() {
                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1', '5'].map(getValue) };
                    block = createBlock('composite', condition);

                    expect(block.getData()).to.be.eql(['1', '5'].map(getValue));
                });

                it('Блок должен удалять элемент в контроле возле которого нажали на (-)', function() {
                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1', '5', '7', '3'].map(getValue) };
                    block = createBlock('composite', condition);

                    var deleteBtn = block.findBlocksInside('btn-delete-value', 'button')[2];

                    deleteBtn.trigger('click');

                    expect(block.getData()).to.be.eql(['1', '5', '3'].map(getValue));
                });

                it('Блок должен добавлять новый элемент после контролла на котором нажали на (+)', function() {
                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1', '5', '7', '3'].map(getValue) };
                    block = createBlock('composite', condition);


                    block.findBlocksInside('btn-add-value', 'button')[2].trigger('click');
                    block.findBlocksInside('btn-add-value', 'button')[0].trigger('click');
                    block.findBlocksInside('btn-add-value', 'button')[4].trigger('click');

                    expect(block.getData()).to.be.eql(['1', '', '5', '7', '', '', '3'].map(getValue));
                });

                it('Если один элемент - контрол удаления должен быть задисейблен', function() {
                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1'].map(getValue) };
                    block = createBlock('composite', condition);

                    var button = block.findBlockInside('btn-delete-value', 'button');

                    expect(button).to.haveMod('disabled', 'yes');
                });

                it('Если в списке после удаления остался один элемент - контрол удаления должен быть задисейблен', function() {
                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1', '2'].map(getValue) };
                    block = createBlock('composite', condition);

                    block.findBlocksInside('btn-delete-value', 'button')[0].trigger('click');

                    var button = block.findBlockInside('btn-delete-value', 'button');

                    expect(button).to.haveMod('disabled', 'yes');
                });

                it('Если в списке более одного элемента - все контролы удаления не должны быть задисейблен', function() {
                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1', '5'].map(getValue) };
                    block = createBlock('composite', condition);

                    var buttons = block.findBlocksInside('btn-delete-value', 'button');

                    buttons.forEach(function(btn) {
                        expect(btn).not.to.haveMod('disabled', 'yes');
                    });
                });

                it('Если число элементов меньше maxCount, то все кнопки добавления нового элемента доступны', function() {
                    var buttons;

                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1'].map(getValue) };
                    block = createBlock('composite', condition);

                    buttons = block.findBlocksInside('btn-add-value', 'button');

                    buttons.forEach(function(btn) {
                        expect(btn).not.to.haveMod('disabled', 'yes');
                    });
                });

                it('Если число элементов больше или равно maxCount, то все кнопки добавления нового элемента задисейблены', function() {
                    var buttons;

                    condition = { field: 'id', id: 'item-1', relation: '==', value: ['1', '5', '6'].map(getValue) };
                    block = createBlock('composite', condition);

                    buttons = block.findBlocksInside('btn-add-value', 'button');

                    buttons.forEach(function(btn) {
                        expect(btn).to.haveMod('disabled', 'yes');
                    });
                });

            });
        });
    });

});
