(function() {
    u.register({
        'filter-condition-edit-control': {
            /**
             * Вычисляет высоту textarea под длину вбитого значения
             * @param {String} value - значение
             * @param {Number} maxSubStringLength
             * @param {Number} maxRowsNum
             * @private
             */
            getTextareaRowsNum: function(value, maxSubStringLength, maxRowsNum) {
                var valLength = value && value.length || 0,
                    rowsByLength = valLength ? Math.ceil(valLength / maxSubStringLength) : 1;

                return rowsByLength <= maxRowsNum ? rowsByLength : maxRowsNum;
            }
        }
    });

})();
