block('filter-condition-edit')(
    js()(function() {
        return {
            modelParams: this.ctx.data.modelParams
        }
    }),

    elem('field-switcher-content')(function() {

        return u.hellipCut(this.ctx.value, 12);
    }),

    content()(function() {
        var ctxData = this.ctx.data,
            errors = this.ctx.data.errors || {
                total: [],
                items: {}
            };

        return [
            {
                block: 'filter-condition-edit',
                elem: 'selects-wrap',
                content: [
                    {
                        block: 'dropdown',
                        mix: [
                            { block: 'filter-condition-edit', elem: 'field-dropdown' },
                            {
                                block: 'b-dropdown-chooser',
                                js: true
                            }
                        ],
                        content: [
                            {
                                block: 'button',
                                mix: [
                                    {
                                        block: 'filter-condition-edit',
                                        elem: 'switcher-btn'
                                    },
                                    {
                                        block: 'dropdown',
                                        elem: 'switcher'
                                    }
                                ],
                                mods: {
                                    theme: 'normal',
                                    arrow: 'down'
                                },
                                content: {
                                    block: 'filter-condition-edit',
                                    elem: 'field-switcher-content',
                                    value: u['i-filter-edit'].getConditionTitle(ctxData.values.field)
                                }
                            },
                            {
                                elem: 'popup',
                                mix: [
                                    {
                                        block: 'dropdown',
                                        elem: 'popup'
                                    },
                                    {
                                        block: 'filter-condition-edit',
                                        elem: 'field-switcher-popup'
                                    }
                                ],
                                content: {
                                    block: 'b-chooser',
                                    mods: { search: 'yes' },
                                    mix: [
                                        { block: 'filter-condition-edit', elem: 'field-chooser' },
                                        {
                                            block: 'b-dropdown-chooser',
                                            elem: 'chooser'
                                        }
                                    ],
                                    content: [
                                        {
                                            block: 'filter-condition-edit',
                                            elem: 'field-chooser-search-wrap',
                                            content: {
                                                block: 'b-chooser',
                                                elem: 'search',
                                                hint: iget2('filter-condition-edit', 'nayti', 'Найти')
                                            }
                                        },
                                        {
                                            elem: 'wrap',
                                            mix: {
                                                block: 'filter-condition-edit',
                                                elem: 'field-chooser-wrap'
                                            },
                                            content: ctxData.conditionsOptionsList.reduce(function(list, condition) {
                                                var mods = {};

                                                condition.selected && (mods.selected = 'yes');
                                                condition.disabled && (mods.disabled = 'yes');

                                                list.push({
                                                    elem: 'item',
                                                    elemMods: mods,
                                                    js: {
                                                        text: condition.value,
                                                        customParams: {
                                                            name: condition.value
                                                        }
                                                    },
                                                    name: condition.value,
                                                    content: u['i-filter-edit'].getConditionTitle(condition.value)
                                                });

                                                condition.hasSeparator && list.push({
                                                    elem: 'item',
                                                    elemMods: { type: 'separator' }
                                                });

                                                return list;
                                            }, [], this)

                                        },
                                        {
                                            block: 'b-chooser',
                                            elem: 'not-found',
                                            mix: {
                                                block: 'filter-condition-edit',
                                                elem: 'field-chooser-not-found'
                                            },
                                            content: iget2('filter-condition-edit', 'usloviya-ne-naydeny', 'Условия не найдены')
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        block: 'select',
                        value: ctxData.values.relation,
                        mix: [{
                            block: 'filter-condition-edit',
                            elem: 'relation-select'
                        }],
                        content: [
                            {
                                block: 'button'
                            },
                            {
                                elem: 'control',
                                content: ctxData.relationsOptionsList.map(function(relation) {
                                    var attrs = {};
                                    relation.selected && (attrs.selected = 'selected');
                                    relation.disabled && (attrs.disabled = 'disabled');
                                    attrs.value = relation.value;

                                    return {
                                        elem: 'option',
                                        attrs: attrs,
                                        content: relation.text
                                    }
                                })
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'value-wrap',
                content: [
                    {
                        block: 'filter-condition-edit-control',
                        mods: { type: u['i-filter-edit'].getValueControlTypeByCondition(ctxData.values) },
                        condition: ctxData.values,
                        itemId: ctxData.values.id,
                        errors: errors,
                        mix: [{
                            block: 'filter-condition-edit',
                            elem: 'value-control'
                        }]
                    },
                    {
                        block: 'b-error-message',
                        mods: { visible: errors.total.length ? 'yes' : '' },
                        js: { path: 'feed-filter-edit.filter.' + ctxData.values.id + '.total' },
                        content: errors.total.map(function(error) {
                            return {
                                block: 'b-error-message',
                                elem: 'text',
                                content: u.escapeHTML(error.text)
                            }
                        })
                    }
                ]
            }
        ];
    })
);
