BEM.DOM.decl({ block: 'filter-condition-edit' }, {
    onSetMod: {
        js: function() {
            this._itemId = this.params.modelParams.id;
            this._model = BEM.MODEL.getOrCreate(this.params.modelParams);

            u.graspSelf.call(this, {
                _fieldSelectBtn: 'button on switcher-btn',
                _fieldSelect: 'b-chooser on field-chooser',
                _relationSelect: 'select on relation-select',
                _valueControl: 'filter-condition-edit-control on value-control'
            });

            this._setCurrentState(this.getData());

            this._initEvents();
        }
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._initCommonEvents();
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initCommonEvents: function() {
        this._subscriptionManager
            .on(this._fieldSelect, 'change', this._onFiledChange, this)
            .on(this._relationSelect, 'change', { field: 'relation' }, this._onControlChange, this)
            .on(this._valueControl, 'change', { field: 'value' }, this._onControlChange, this);
    },

    _onFiledChange: function(e, data) {
        //это был change на снятие галки с предыдущего
        if (!data.selected) { return; }

        this._fieldSelectBtn.elem('text').html(BEMHTML.apply({
            block: 'filter-condition-edit',
            elem: 'field-switcher-content',
            value: u['i-filter-edit'].getConditionTitle(data.customParams.name)
        }));

        this._onControlChange({ data: { field: 'field' } });
    },

    /**
     * Реакция на событие изменения контрола в блоке
     * @param {Object} e
     * @returns {BEM}
     * @private
     */
    _onControlChange: function(e) {
        var changedField = e.data.field,
            value = this.getData();

        //в filter-conditions-list нам не нужно подписываться на каждый блок filter-condition-edit отдельно
        this.__self.trigger('change', {
            field: changedField,
            value: value,
            prevValue: this._getCurrentState()
        });

        this._model.set(changedField, value[changedField]);
        this._setCurrentState(value);

        return this;
    },

    /**
     * Сохраняет текущие значения контролов
     * @param {Object} state
     * @param {String} state.relation
     * @param {String} state.field
     * @param {String} state.value
     * @private
     */
    _setCurrentState: function(state) {
        this._currentState = u._.extend({}, state);

    },

    /**
     * Возвращает последние сохраненные значения контролов
     * @returns {BEM}
     * @private
     */
    _getCurrentState: function() {
        return this._currentState;
    },

    getData: function() {
        return {
            id: this._itemId,
            field: this._fieldSelect.getSelected().customParams.name,
            relation: this._relationSelect.val(),
            value: this._valueControl.getData()
        }
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base();
    }
});
