describe('filter-condition-edit', function() {
    var block,
        condition,
        defaultCond = {
            field: 'id',
            relation: 'like',
            value: ['1']
        },

        sandbox;

    function createBlock(condition) {
        condition = condition || {};

        return u.createBlock({
            block: 'filter-condition-edit',
            data: {
                modelParams: {
                    id: 'id',
                    name: 'filter-condition-edit',
                    parentName: 'b-feed-filter-edit',
                    parentId: 'parent-id'
                },
                conditionsOptionsList: ['category', 'id'].map(function(field) {
                    return {
                        value: field,
                        selected: field === condition.field,
                        text: field
                    };
                }),
                relationsOptionsList: ['==', '<->', 'like'].map(function(relation) {
                    return {
                        value: relation,
                        selected: relation === condition.relation,
                        text: relation
                    };
                }),
                values: condition
            }
        }, { inject: true });
    }

    beforeEach(function() {
        sandbox = sinon.sandbox.create({
            useFakeTimers: true
        });

        sandbox.stub(u['i-filter-edit'], 'getValueControlTypeByCondition').callsFake(function() {
            return 'textarea';
        });

        sandbox.stub(u['i-filter-edit'], 'getConditionTitle').callsFake(function(relation) {
            return relation;
        });
    });

    afterEach(function() {
        sandbox.restore();
        block.destruct();
    });

    it('При отрисовке с непустым значением getData вернет это значение', function() {

        block = createBlock(defaultCond);

        expect(u._.pick(block.getData(), ['field', 'relation', 'value'])).to.be.eql(defaultCond);
    });

    describe('Проверка событий', function() {
        beforeEach(function() {
            block = createBlock(defaultCond);

            sandbox.spy(BEM.blocks['filter-condition-edit'], 'trigger');
        });

        it('При изменении селекта для ввода field должен триггериться change с изменившимся значением', function() {
            block._fieldSelect.check('category');

            expect(BEM.blocks['filter-condition-edit']).to.triggerEvent(
                'change',
                {
                    field: 'field',
                    value: {
                        id: 'id',
                        field: 'category',
                        relation: 'like',
                        value: ['1']
                    },
                    prevValue: {
                        id: 'id',
                        field: 'id',
                        relation: 'like',
                        value: ['1']
                    }
                }
            )
        });

        it('При изменении селекта для ввода relation должен триггериться change с изменившимся значением', function() {
            block._relationSelect.val('==');

            expect(BEM.blocks['filter-condition-edit']).to.triggerEvent(
                'change',
                {
                    field: 'relation',
                    value: {
                        id: 'id',
                        field: 'id',
                        relation: '==',
                        value: ['1']
                    },
                    prevValue: {
                        id: 'id',
                        field: 'id',
                        relation: 'like',
                        value: ['1']
                    }
                }
            )
        });

        it('При изменении селекта для ввода value должен триггериться change с изменившимся значением', function() {
            block._valueControl._textarea.val('2');

            expect(BEM.blocks['filter-condition-edit']).to.triggerEvent(
                'change',
                {
                    field: 'value',
                    value: {
                        id: 'id',
                        field: 'id',
                        relation: 'like',
                        value: ['2']
                    },
                    prevValue: {
                        id: 'id',
                        field: 'id',
                        relation: 'like',
                        value: ['1']
                    }
                }
            )
        });
    });
});
