block('filter-conditions-list')(
    def()(function() {
        return applyNext({
            'mods.empty': !!this.ctx.conditions && this.ctx.conditions.length ? '' : 'yes'
        });
    }),

    mix()(function() {
        return {
            block: 'i-controls-overseer',
            js: { of: { block: 'filter-conditions-list', elem: 'condition-control' } }
        }
    }),

    js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        return {
            block: 'composite',
            mix: [
                { block: 'filter-conditions-list', elem: 'conditions' },
                {
                    block: 'list-style',
                    mods: {
                        theme: 'clean',
                        numeration: 'yes',
                        box: 'yes',
                        deletion: 'icon'
                    }
                }
            ],
            layout: {
                block: 'filter-conditions-list',
                elem: 'conditions-list'
            },
            itemView: {
                block: 'filter-conditions-list',
                elem: 'item'
            }
        }
    }),

    elem('item')(
        mix()(function() {
            return [
                { block: 'list-style', elem: 'item' },
                {
                    block: 'filter-conditions-list',
                    elem: 'composite-item',
                    elemMods: { id: this.ctx.itemData.id }
                }
            ];
        }),

        content()(function() {

            return [
                {
                    elem: 'conditions-separator',
                    content: iget2('filter-conditions-list', 'i', 'и')
                },
                {
                    block: 'filter-condition-edit',
                    data: this.ctx.itemData
                },
                {
                    block: 'b-control-remove-button',
                    mods: {
                        icon: 'basket',
                        state: this.ctx.disableRemove ? 'disabled' : ''
                    },
                    data: { itemId: this.ctx.itemData.id },
                    mix: [
                        {
                            block: 'filter-conditions-list',
                            elem: 'condition-control'
                        },
                        { block: 'list-style', elem: 'remove' }
                    ]
                }
            ];
        })
    ),

    elem('conditions-list').content()(function() {
        return [
            {
                block: 'composite',
                mix: [
                    {
                        block: 'list-style',
                        elem: 'items'
                    },
                    {
                        block: 'filter-conditions-list',
                        elem: 'items'
                    }
                ],
                elem: 'items'
            },
            {
                elem: 'filter-condition-list-empty',
                content: iget2('filter-conditions-list', 'spisok-usloviy-pust', 'Список условий пуст')
            },
            {
                block: 'b-control-add-button',
                mix: [{ block: 'filter-conditions-list', elem: 'condition-control' }],
                content: iget2('filter-conditions-list', 'novoe-uslovie', 'Новое условие')
            }
        ];
    })
);
