describe('filter-conditions-list', function() {
    var block,
        filterId = 111,
        adgroupId = 11,
        viewModel,
        groupModel,
        adgroupType = 'dynamic',
        sandbox,
        conditionsList10Stub = [
            { field: 'categoryId', relation: '<', value: ['3'], id: 1 },
            { field: 'categoryId', relation: '>', value: ['3'], id: 2 },
            { field: 'categoryId', relation: '==', value: ['3'], id: 3 },
            { field: 'categoryId', relation: '<->', value: [{ min: 2, max: 4 }], id: 4 },
            { field: 'id', relation: '<', value: ['3'], id: 5 },
            { field: 'id', relation: '>', value: ['3'], id: 6 },
            { field: 'id', relation: '==', value: ['3'], id: 7 },
            { field: 'id', relation: '<->', value: [{ min: 2, max: 4 }], id: 8 },
            { field: 'vendor', relation: 'ilike', value: ['3'], id: 9 },
            { field: 'vendor', relation: 'not ilike', value: ['3'], id: 10 }
        ];

    function createModels() {
        var adgroupType = 'dynamic',
            filterData = getFeedFilterStub(),
            groupData = getGroupStub({}, [filterData]);

        groupModel = BEM.MODEL.create({ name: u.campaign.getGroupModelName(adgroupType), id: adgroupId }, groupData);
        viewModel = BEM.MODEL.create({ name: 'b-feed-filter-edit' }, filterData);
    }

    function destructModels() {
        viewModel && viewModel.destruct();
        groupModel && groupModel.destruct();
    }

    function getFeedFilterStub(data) {
        var stub = u['i-test-stubs__feed-filter']()[adgroupType];

        data = data || {};

        return u._.extend(stub, data, {
            filter_id: filterId,
            adgroup_id: adgroupId,
            adgroupModelId: adgroupId
        });
    }

    function getGroupStub(data, filters) {
        return u._.extend({
            modelId: adgroupId,
            cid: 'campaign-id',
            group_name: '003 Мск Main',
            banners_quantity: 17,
            banners_arch_quantity: 0,
            adgroup_id: adgroupId,
            adgroup_type: adgroupType,
            banners: [],
            feed_filters: filters
        }, data);
    }

    function createBlock(conditions) {
        block = u.createBlock({
            block: 'filter-conditions-list',
            modelParams: {
                name: 'b-feed-filter-edit',
                id: filterId
            }
        }, { inject: true });
    }

    before(function() {
        sandbox = sinon.sandbox.create({
            useFakeTimers: true,
            useFakeServer: true
        });

        BEM.blocks['i-filter-edit'].loadConfig();
        sandbox.server.respond(JSON.stringify(u['i-test-stubs__feed-filters-config']()));
    });

    before(function() {
        createModels();

        sandbox = sinon.sandbox.create({
            useFakeTimers: true,
            useFakeServer: true
        });
    });

    after(function() {
        destructModels();
    });


    afterEach(function() {
        block.destruct();
        sandbox.restore();
    });

    it('Если в view-модели не пустой список условий в поле condition, то у блок не будет модификатора _empty_yes', function() {
        createBlock();
        expect(block).not.to.haveMod('empty');

    });

    it('Если в view-модели пустой список условий в поле condition, то блок отрисовывается с модификатором _empty_yes', function() {
        viewModel.set('condition', []);
        createBlock();
        expect(block).to.haveMod('empty', 'yes');
    });

    it('При событии add на блоке i-controls-overseer в view-модель должно добавиться новое условие', function() {
        createBlock();

        block.findBlockOn('i-controls-overseer').trigger('add');
        sandbox.clock.tick(10);

        expect(viewModel.get('condition').length()).to.be.equal(1);
    });

    it('При добавлении нового условия должнен сбросится модификатор _empty_yes', function() {
        viewModel.set('condition', []);
        createBlock();

        block.findBlockOn('i-controls-overseer').trigger('add');
        sandbox.clock.tick(10);
        expect(block).not.to.haveMod('empty');
    });

    it('При событии remove на i-controls-overseer из модели должно удалиться условие с заданным в параметрах события id', function() {
        var itemId = 12345;

        viewModel.set('condition', [{ field: 'categoryId', relation: '<', value: ['3'], id: itemId }]);
        createBlock();
        block.findBlockOn('i-controls-overseer').trigger('remove', { data: { itemId: itemId } });
        sandbox.clock.tick(10);
        expect(viewModel.get('condition').length()).to.be.equal(0);
    });

    it('При удалении последнего в списке условия у блока должен проставиться модификатор _empty_yes', function() {
        var itemId = 12345;

        viewModel.set('condition', [{ field: 'categoryId', relation: '<', value: ['3'], id: itemId }]);
        createBlock();
        block.findBlockOn('i-controls-overseer').trigger('remove', { data: { itemId: itemId } });
        expect(block).to.haveMod('empty', 'yes');
    });

    it('Если в списке 10 или более условий, кнопка добавления нового должна быть задисаблена', function() {
        viewModel.set('condition', conditionsList10Stub);

        createBlock();

        expect(block.findBlockInside('b-control-add-button')).to.haveMod('state', 'disabled');
    });

    it('Если в списке было 10 условий и одно удалили, то _state_disabled с кнопки добавления нового условие должно сняться', function() {
        viewModel.set('condition', conditionsList10Stub);
        createBlock();
        block.findBlockOn('i-controls-overseer').trigger('remove', { data: { itemId: 1 } });

        expect(block.findBlockInside('b-control-add-button')).not.to.haveMod('state', 'disabled');
    });

    it('При событии change на блоке, если изменилось value, модель соответствующая этому элементу должна обновить свое значение', function() {
        viewModel.set('condition', conditionsList10Stub);
        createBlock();

        BEM.blocks['filter-condition-edit']
            .trigger('change',
                {
                    field: 'value',
                    value: { field: 'categoryId', relation: '>', value: ['5'], id: 1 },
                    prevValue: { field: 'categoryId', relation: '>', value: ['3'], id: 1 }
                });

        var value = viewModel.get('condition').getById(1).toJSON().value.slice();

        expect(value).to.be.eql['5'];
    });

    describe('Реация на изменение field в элементе списка', function() {
        var changeFieldEvent = function() {
            BEM.blocks['filter-condition-edit']
              .trigger('change',
                  {
                      field: 'field',
                      value: { field: 'price', relation: '>', value: ['3'], id: 1 },
                      prevValue: { field: 'categoryId', relation: '>', value: ['3'], id: 1 }
                  });
        };

        it('Модель должна обновить свое значение', function() {
            viewModel.set('condition', conditionsList10Stub);
            createBlock();
            changeFieldEvent();

            expect(viewModel.get('condition').getById(1).toJSON().field).to.be.equal('price');
        });

        it('Должен перерисоваться блок условий', function() {
            viewModel.set('condition', conditionsList10Stub);
            createBlock();

            var spy = sandbox.spy(block._list, 'update');

            sandbox.stub(block, 'afterCurrentEvent').callsFake(function(func) {
                func.call(this);
            });

            changeFieldEvent();
            sandbox.clock.tick(100);
            expect(spy.called).to.be.true;

        });

        it('Должен обновиться объект доступных состояний', function() {
            viewModel.set('condition', conditionsList10Stub);
            createBlock();

            var spy = sandbox.spy(block._availableStatesHash, 'updateAvailableHash');

            changeFieldEvent();

            expect(spy.alwaysCalledWith('change-filter', {
                filter: 'price',
                prevFilter: 'categoryId',
                prevSubFilter: '>',
                subFilter: '>'
            })).to.be.true;
        })
    });

    describe('Реация на изменение relation в элементе списка', function() {
        var changeFieldEvent = function() {
            BEM.blocks['filter-condition-edit']
              .trigger('change',
                  {
                      field: 'relation',
                      value: { field: 'categoryId', relation: '>', value: ['3'], id: 1 },
                      prevValue: { field: 'categoryId', relation: '<', value: ['3'], id: 1 }
                  });
        };

        it('Модель должна обновить свое значение', function() {
            viewModel.set('condition', [{ field: 'categoryId', relation: '<', value: ['3'], id: 1 }]);
            createBlock();
            changeFieldEvent();

            expect(viewModel.get('condition').getById(1).toJSON().relation).to.be.equal('>');
        });

        it('Должен перерисоваться блок условий', function() {
            viewModel.set('condition', [{ field: 'categoryId', relation: '<', value: ['3'], id: 1 }]);
            createBlock();

            var spy = sandbox.spy(block._list, 'update');

            sandbox.stub(block, 'afterCurrentEvent').callsFake(function(func) {
                func.call(this);
            });

            changeFieldEvent();
            expect(spy.called).to.be.true;
        });

        it('Должен обновиться объект доступных состояний', function() {
            viewModel.set('condition', [{ field: 'categoryId', relation: '<', value: ['3'], id: 1 }]);
            createBlock();

            var spy = sandbox.spy(block._availableStatesHash, 'updateAvailableHash');

            changeFieldEvent();

            expect(spy.alwaysCalledWith('change-sub-filter', {
                filter: 'categoryId',
                prevFilter: 'categoryId',
                prevSubFilter: '<',
                subFilter: '>'
            })).to.be.true;
        })
    });




});
