block('filter-conditions-tree')(
    js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        var grouped = this.ctx.grouped,
            defaultRelation;

        if (!grouped.price) {
            defaultRelation = { field: 'price', relation: '<->' };

            grouped.price = [u._.extend(defaultRelation, u['i-filter-edit'].getDefaultValue(defaultRelation))];
        }
        if (!grouped.vendor) {
            defaultRelation = { field: 'vendor', relation: 'ilike' };

            grouped.vendor = [u._.extend(defaultRelation, u['i-filter-edit'].getDefaultValue(defaultRelation))];
        }
        return [
            {
                elem: 'row',
                content: [
                    {
                        elem: 'row-title'
                    },
                    {
                        elem: 'row-content',
                        content: [
                            {
                                elem: 'wrapper',
                                mix: {
                                    block: 'b-error-control',
                                    js: { path: 'feed-filter-edit.filter.' + grouped.categoryId[0].id + '.total' }
                                },
                                content: {
                                    block: 'b-feed-category-chooser',
                                    mix: [
                                        { block: 'filter-conditions-tree', elem: 'category-chooser' }
                                    ],
                                    modelData: this.ctx.modelData,
                                    feedTree: this.ctx.categories,
                                    selectedItems: grouped.categoryId[0].value || []
                                }
                            },
                            {
                                block: 'b-error-message',
                                js: { path: 'feed-filter-edit.filter.' + grouped.categoryId[0].id + '.total' }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'row-title',
                        content: iget2('filter-conditions-tree', 'diapazon-cen', 'Диапазон цен')
                    },
                    {
                        elem: 'row-content',
                        content: [
                            {
                                block: 'filter-condition-edit-control',
                                mix: { block: 'filter-conditions-tree', elem: 'price-range' },
                                mods: { type: 'composite' },
                                hideCompositeControls: true,
                                itemId: grouped.price[0].id,
                                condition: grouped.price[0]
                            },
                            {
                                block: 'b-error-message',
                                js: { path: 'feed-filter-edit.filter.' + grouped.price[0].id + '.total' }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'row-title',
                        content: iget2('filter-conditions-tree', 'proizvoditeli', 'Производители')
                    },
                    {
                        elem: 'row-content',
                        content: [
                            {
                                block: 'filter-condition-edit-control',
                                mods: { type: 'textarea' },
                                mix: { block: 'filter-conditions-tree', elem: 'vendor-input' },
                                rowsNumber: 5,
                                skipAdaptTextareaHeight: true,
                                skipCounter: true,
                                itemId: grouped.vendor[0].id,
                                condition: grouped.vendor[0]
                            },
                            {
                                block: 'b-error-message',
                                js: { path: 'feed-filter-edit.filter.' + grouped.vendor[0].id + '.total' }
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
